/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.tile;

import com.mojang.nbt.tags.CompoundTag;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.Catalyst;

public abstract class TEFeature {
    protected static Map<String, Class<? extends TEFeature>> AVAILABLE_FEATURES = new HashMap<String, Class<? extends TEFeature>>();
    public final String id;
    public World world;
    public int x;
    public int y;
    public int z;

    protected TEFeature(String id, World world, int x, int y, int z) {
        this.id = id;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    protected TEFeature(String id, World world) {
        this.id = id;
        this.world = world;
    }

    public static void registerFeature(String id, Class<? extends TEFeature> feature) {
        AVAILABLE_FEATURES.put(id, feature);
    }

    public static Class<? extends TEFeature> getFeatureClass(String id) {
        return AVAILABLE_FEATURES.get(id);
    }

    public static Map<String, Class<? extends TEFeature>> getFeatureClasses() {
        return Collections.unmodifiableMap(AVAILABLE_FEATURES);
    }

    public static TEFeature createFeature(String id, World world, int x, int y, int z) {
        Class<? extends TEFeature> clazz = AVAILABLE_FEATURES.get(id);
        if (clazz == null) {
            throw new RuntimeException("No tile entity feature with id '" + id + "'!");
        }
        try {
            Constructor<? extends TEFeature> c = clazz.getDeclaredConstructor(String.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            c.setAccessible(true);
            TEFeature feature = c.newInstance(id, world, x, y, z);
            c.setAccessible(false);
            return feature;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create tile entity feature: '" + id + "'!", e);
        }
    }

    public static TEFeature loadFeature(CompoundTag nbt, World world) {
        String id = nbt.getString("id");
        Class<? extends TEFeature> clazz = AVAILABLE_FEATURES.get(id);
        if (clazz == null) {
            Catalyst.LOGGER.error("No tile entity feature with id '{}'!", (Object)id);
            return null;
        }
        try {
            Constructor<? extends TEFeature> c = clazz.getDeclaredConstructor(String.class, World.class);
            c.setAccessible(true);
            TEFeature feature = c.newInstance(id, world);
            feature.readFromNBT(nbt);
            c.setAccessible(false);
            return feature;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create tile entity feature: '" + id + "'!", e);
        }
    }

    public Block<?> getBlock() {
        return this.world.getBlock(this.x, this.y, this.z);
    }

    public int getBlockMetadata() {
        return this.world.getBlockMetadata(this.x, this.y, this.z);
    }

    public TileEntity getTile() {
        return this.world.getTileEntity(this.x, this.y, this.z);
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        this.x = nbttagcompound.getInteger("x");
        this.y = nbttagcompound.getInteger("y");
        this.z = nbttagcompound.getInteger("z");
    }

    public void writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.putString("id", this.id);
        nbttagcompound.putInt("x", this.x);
        nbttagcompound.putInt("y", this.y);
        nbttagcompound.putInt("z", this.z);
    }

    public abstract void tick();

    public abstract void init(Block<?> var1);
}

