/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.vector;

import com.mojang.nbt.tags.CompoundTag;

public class Vec4i {
    public int x;
    public int y;
    public int z;
    public int w;

    public Vec4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vec4i() {
        this.w = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public Vec4i(int size) {
        this.z = this.w = size;
        this.y = this.w;
        this.x = this.w;
    }

    public Vec4i(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public double distanceTo(Vec4i vec3f) {
        int d = vec3f.x - this.x;
        int d1 = vec3f.y - this.y;
        int d2 = vec3f.z - this.z;
        int d3 = vec3f.w - this.w;
        return Math.sqrt(d * d + d1 * d1 + d2 * d2 + d3 * d3);
    }

    public Vec4i add(int value) {
        this.x += value;
        this.y += value;
        this.z += value;
        this.w += value;
        return this;
    }

    public Vec4i subtract(int value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        this.w -= value;
        return this;
    }

    public Vec4i divide(int value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
        this.w /= value;
        return this;
    }

    public Vec4i multiply(int value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        this.w *= value;
        return this;
    }

    public Vec4i add(Vec4i value) {
        this.x += value.x;
        this.y += value.y;
        this.z += value.z;
        this.w += value.w;
        return this;
    }

    public Vec4i subtract(Vec4i value) {
        this.x -= value.x;
        this.y -= value.y;
        this.z -= value.z;
        this.w -= value.w;
        return this;
    }

    public Vec4i divide(Vec4i value) {
        this.x /= value.x;
        this.y /= value.y;
        this.z /= value.z;
        this.w /= value.w;
        return this;
    }

    public Vec4i multiply(Vec4i value) {
        this.x *= value.x;
        this.y *= value.y;
        this.z *= value.z;
        this.w *= value.w;
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.putInt("x", this.x);
        tag.putInt("y", this.y);
        tag.putInt("z", this.z);
        tag.putInt("w", this.w);
        return tag;
    }

    public void readFromNBT(CompoundTag tag) {
        this.x = tag.getInteger("x");
        this.y = tag.getInteger("y");
        this.z = tag.getInteger("z");
        this.w = tag.getInteger("w");
    }

    public Vec4i copy() {
        return new Vec4i(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return String.format("(%d, %d, %d, %d)", this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec4i vec = (Vec4i)o;
        if (this.x != vec.x) {
            return false;
        }
        if (this.y != vec.y) {
            return false;
        }
        if (this.z != vec.w) {
            return false;
        }
        return this.w == vec.w;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + this.w;
        return result;
    }
}

