/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.BlockLogicSupplier;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.sound.BlockSound;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.helper.IdSupplierHelper;
import turniplabs.halplibe.mixin.accessors.BlockAccessor;
import turniplabs.halplibe.mixin.accessors.BlocksAccessor;
import turniplabs.halplibe.util.registry.IdSupplier;
import turniplabs.halplibe.util.registry.RunLengthConfig;
import turniplabs.halplibe.util.registry.RunReserves;
import turniplabs.halplibe.util.toml.Toml;

public final class BlockBuilder
implements Cloneable {
    @NotNull
    private final String modId;
    @Nullable
    private Float hardness = null;
    @Nullable
    private Float resistance = null;
    @Nullable
    private Integer luminance = null;
    @Nullable
    private Integer lightOpacity = null;
    @Nullable
    private Float slipperiness = null;
    private boolean immovable = false;
    private boolean useInternalLight = false;
    private boolean visualUpdateOnMetadata = false;
    @Nullable
    private Boolean tickOnLoad = null;
    private boolean infiniburn = false;
    private int @Nullable [] flammability = null;
    @Nullable
    private BlockSound blockSound = null;
    @Nullable
    private BlockLambda<ItemBlock<?>> customBlockItem = null;
    @Nullable
    private Tag<Block<?>>[] tags = null;
    private String @NotNull [] textures = new String[6];
    @Nullable
    private String itemIcon = null;
    @Nullable
    private Supplier<TileEntity> entitySupplier = null;

    public BlockBuilder(@NotNull String modId) {
        this.modId = modId;
    }

    public BlockBuilder clone() {
        try {
            BlockBuilder builder = (BlockBuilder)super.clone();
            builder.textures = new String[6];
            System.arraycopy(this.textures, 0, builder.textures, 0, this.textures.length);
            return builder;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public BlockBuilder setTileEntity(@Nullable Supplier<TileEntity> tileEntitySupplier) {
        BlockBuilder builder = this.clone();
        builder.entitySupplier = tileEntitySupplier;
        return builder;
    }

    public BlockBuilder setHardness(float hardness) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.hardness = Float.valueOf(hardness);
        return blockBuilder;
    }

    public BlockBuilder setResistance(float resistance) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.resistance = Float.valueOf(resistance);
        return blockBuilder;
    }

    public BlockBuilder setLuminance(int luminance) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.luminance = luminance;
        return blockBuilder;
    }

    public BlockBuilder setLightOpacity(int lightOpacity) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.lightOpacity = lightOpacity;
        return blockBuilder;
    }

    public BlockBuilder setSlipperiness(float slipperiness) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.slipperiness = Float.valueOf(slipperiness);
        return blockBuilder;
    }

    public BlockBuilder setFlammability(int chanceToCatchFire, int chanceToDegrade) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.flammability = new int[]{chanceToCatchFire, chanceToDegrade};
        return blockBuilder;
    }

    public BlockBuilder setImmovable() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.immovable = true;
        return blockBuilder;
    }

    public BlockBuilder setUnbreakable() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.hardness = Float.valueOf(-1.0f);
        return blockBuilder;
    }

    public BlockBuilder setInfiniburn() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.infiniburn = true;
        return blockBuilder;
    }

    public BlockBuilder setUseInternalLight() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.useInternalLight = true;
        return blockBuilder;
    }

    public BlockBuilder setVisualUpdateOnMetadata() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.visualUpdateOnMetadata = true;
        return blockBuilder;
    }

    public BlockBuilder setTickOnLoad() {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tickOnLoad = true;
        return blockBuilder;
    }

    public BlockBuilder setTicking(boolean ticking) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tickOnLoad = ticking;
        return blockBuilder;
    }

    public BlockBuilder setBlockSound(BlockSound blockSound) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.blockSound = blockSound;
        return blockBuilder;
    }

    public BlockBuilder setBlockItem(BlockLambda<ItemBlock<?>> customBlockItem) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.customBlockItem = customBlockItem;
        return blockBuilder;
    }

    @SafeVarargs
    public final BlockBuilder setTags(Tag<Block<?>> ... tags) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tags = tags;
        return blockBuilder;
    }

    @SafeVarargs
    public final BlockBuilder addTags(Tag<Block<?>> ... tags) {
        BlockBuilder blockBuilder = this.clone();
        blockBuilder.tags = (Tag[])ArrayUtils.addAll((Object[])this.tags, (Object[])tags);
        return blockBuilder;
    }

    public <T extends BlockLogic> Block<T> build(String name, int numericId, BlockLogicSupplier<T> blockLogicSupplier) {
        return this.build(name.replace("_", "."), name, numericId, blockLogicSupplier);
    }

    public <T extends BlockLogic> Block<T> build(String translationKey, String name, int numericId, BlockLogicSupplier<T> blockLogicSupplier) {
        Block block = Blocks.register((String)String.format("%s.%s", this.modId, translationKey), (String)String.format("%s:block/%s", this.modId, name), (int)numericId, blockLogicSupplier);
        if (this.hardness != null) {
            block.withHardness(this.hardness.floatValue());
        }
        if (this.resistance != null) {
            block.withBlastResistance(this.resistance.floatValue());
        }
        if (this.luminance != null) {
            block.withLightEmission(this.luminance.intValue());
        }
        if (this.lightOpacity != null) {
            block.withLightBlock(this.lightOpacity.intValue());
        }
        if (this.slipperiness != null) {
            block.friction = this.slipperiness.floatValue();
        }
        block.withLitInteriorSurface(this.useInternalLight);
        if (this.immovable) {
            block.withImmovableFlagSet();
        }
        if (this.flammability != null) {
            BlockLogicFire.setFlammable((Block)block, (int)this.flammability[0], (int)this.flammability[1]);
        }
        if (this.infiniburn) {
            block.withTags(new Tag[]{BlockTags.INFINITE_BURN});
        }
        if (this.visualUpdateOnMetadata) {
            block.withDisabledNeighborNotifyOnMetadataChange();
        }
        if (this.tickOnLoad != null) {
            block.setTicking(this.tickOnLoad.booleanValue());
        }
        if (this.blockSound != null) {
            block.withSound(this.blockSound);
        }
        if (this.entitySupplier != null) {
            block.withEntity(this.entitySupplier);
        }
        if (this.tags != null) {
            block.withTags(this.tags);
        }
        if (this.customBlockItem != null) {
            block.setBlockItem(() -> (Item)this.customBlockItem.run(block));
        }
        if (BlocksAccessor.hasInit()) {
            block.init();
            Item item = (Item)block.blockItemSupplier.get();
            if (((BlockAccessor)block).getStatParent() != null) {
                item.setStatParent(((BlockAccessor)block).getStatParent());
            }
            Item.itemsList[item.id] = item;
            block.getLogic().initializeBlock();
            BlocksAccessor.cacheBlock(block);
        }
        return block;
    }

    @FunctionalInterface
    public static interface BlockLambda<T> {
        public T run(Block<?> var1);
    }

    public static class Registry {
        public static int highestVanilla;
        private static final RunReserves reserves;

        public static int findOpenIds(int count) {
            int run = 0;
            for (int i = highestVanilla; i < Blocks.blocksList.length; ++i) {
                if (Blocks.blocksList[i] == null && !reserves.isReserved(i)) {
                    if (run >= count) {
                        return i - run;
                    }
                    ++run;
                    continue;
                }
                run = 0;
            }
            return -1;
        }

        public static int findLength(int id, int terminate) {
            int run = 0;
            for (int i = id; i < Blocks.blocksList.length; ++i) {
                if (Blocks.blocksList[i] == null && !reserves.isReserved(i)) {
                    if (++run < terminate) continue;
                    return terminate;
                }
                return run;
            }
            return run;
        }

        public static void reserveRuns(String modId, Toml runs, int neededIds, Consumer<IdSupplier> function) {
            RunLengthConfig cfg = new RunLengthConfig(runs, neededIds);
            cfg.register(reserves);
            IdSupplierHelper.scheduleSmartRegistry(() -> {
                IdSupplier supplier = new IdSupplier(modId, reserves, cfg, neededIds);
                function.accept(supplier);
                supplier.validate();
            });
        }

        static {
            reserves = new RunReserves(Registry::findOpenIds, Registry::findLength);
        }
    }
}

