/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.demo.DemoManager;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;

public abstract class Tooltip<T> {
    private final List<Class<? extends T>> toolTipClasses = new ArrayList<Class<? extends T>>();

    public Tooltip() {
        BTWaila.LOGGER.info("Adding tooltips for: " + this.getClass().getSimpleName());
        this.initTooltip();
        DemoManager.getInstance().register(this.tooltipDemo(DemoManager.random));
    }

    public void addClass(Class<? extends T> entityClass) {
        this.toolTipClasses.add(entityClass);
    }

    public boolean isInstance(Object object) {
        return this.getClassType().isInstance(object);
    }

    public Class getClassType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public boolean isInList(Class<?> entityClass) {
        return this.toolTipClasses.contains(entityClass);
    }

    public abstract void initTooltip();

    public abstract void drawAdvancedTooltip(T var1, AdvancedInfoComponent var2);

    public DemoEntry tooltipDemo(Random random) {
        return null;
    }
}

