/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.World;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.demo.TileEntityDemoChest;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;

public class InventoryTooltip
extends TileTooltip<Container> {
    @Override
    public void initTooltip() {
        this.addClass(TileEntityChest.class);
        this.addClass(TileEntityDispenser.class);
        this.addClass(TileEntityDemoChest.class);
    }

    @Override
    public void drawAdvancedTooltip(Container inventory, AdvancedInfoComponent advancedInfoComponent) {
        if (inventory instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inventory;
            if (chest.worldObj != null) {
                inventory = BlockLogicChest.getInventory((World)chest.worldObj, (int)chest.x, (int)chest.y, (int)chest.z);
            }
        }
        int max = inventory.getContainerSize();
        int current = 0;
        for (int i = 0; i < max; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null) continue;
            current += itemStack.stackSize;
        }
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.inventory.storage").replace("{current}", String.valueOf(current)).replace("{max}", String.valueOf(max * inventory.getMaxStackSize())), 0);
        advancedInfoComponent.drawInventory(inventory, 0);
    }

    @Override
    public DemoEntry tooltipDemo(Random random) {
        Block chest = Blocks.CHEST_PLANKS_OAK_PAINTED;
        return new DemoEntry(chest, 128, new TileEntityDemoChest(random), new ItemStack[]{new ItemStack(chest, 1, 128)});
    }
}

