/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips.block;

import java.util.Random;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.NamespaceID;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;

public class MobSpawnerTooltip
extends TileTooltip<TileEntityMobSpawner> {
    @Override
    public void initTooltip() {
        this.addClass(TileEntityMobSpawner.class);
    }

    @Override
    public void drawAdvancedTooltip(TileEntityMobSpawner mobSpawner, AdvancedInfoComponent advancedInfoComponent) {
        boolean canSpawn = true;
        int canSpawnColor = 0xAFFFAF;
        WorldClient world = advancedInfoComponent.getGame().currentWorld;
        if (world == null || world.getDifficulty().id() == 0 || mobSpawner.getMobId() == null || mobSpawner.getMobId().equalsIgnoreCase("none")) {
            canSpawn = false;
            canSpawnColor = 0xFFAFAF;
        }
        int delay = mobSpawner.delay;
        String entityName = mobSpawner.getMobId();
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.spawner.bound").replace("{name}", entityName != null ? entityName : BTWaila.translator.translateKey("btwaila.tooltip.spawner.name.default")), 0);
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.spawner.canspawn").replace("{flag}", String.valueOf(canSpawn)), 0, canSpawnColor);
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.spawner.spawndelay").replace("{delay}", String.valueOf(delay)), 0, canSpawnColor);
    }

    @Override
    public DemoEntry tooltipDemo(Random random) {
        TileEntityMobSpawner demoSpawner = new TileEntityMobSpawner();
        NamespaceID[] entityIds = EntityDispatcher.idToClassMap.keySet().toArray(new NamespaceID[0]);
        demoSpawner.setMobId(entityIds[random.nextInt(entityIds.length)].toString());
        Block spawner = Blocks.MOBSPAWNER;
        return new DemoEntry(spawner, 0, (TileEntity)demoSpawner, new ItemStack[]{spawner.getDefaultStack()});
    }
}

