/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips.entity;

import java.util.Random;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.EntityTooltip;

public class MinecartTooltip
extends EntityTooltip<EntityMinecart> {
    @Override
    public void initTooltip() {
        this.addClass(EntityMinecart.class);
    }

    @Override
    public void drawAdvancedTooltip(EntityMinecart entityMinecart, AdvancedInfoComponent advancedInfoComponent) {
        switch (entityMinecart.getType()) {
            case 0: {
                String entityName = AdvancedInfoComponent.getEntityName(entityMinecart.passenger);
                advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.minecart.passenger").replace("{name}", entityName), 0);
                break;
            }
            case 1: {
                int max = entityMinecart.getContainerSize();
                int current = 0;
                for (int i = 0; i < max; ++i) {
                    ItemStack itemStack = entityMinecart.getItem(i);
                    if (itemStack == null) continue;
                    current += itemStack.stackSize;
                }
                advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.minecart.storage").replace("{current}", String.valueOf(current)).replace("{max}", String.valueOf(max * entityMinecart.getMaxStackSize())), 0);
                advancedInfoComponent.drawInventory((Container)entityMinecart, 0);
                break;
            }
            case 2: {
                advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.minecart.fuel").replace("{fuel}", String.valueOf(entityMinecart.getFuel())), 0);
            }
        }
    }

    @Override
    public DemoEntry tooltipDemo(Random random) {
        EntityMinecart demoMinecart = new EntityMinecart(null);
        demoMinecart.setType((byte)random.nextInt(3));
        return new DemoEntry((Entity)demoMinecart);
    }
}

