/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.world.World;

public class EntityEntryFallingBlock
extends EntityEntry<EntityFallingBlock> {
    @Override
    public void onTick(EntityFallingBlock entity) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, final EntityFallingBlock sand) {
        final TextCycleElement<Integer> blockIdCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, 0, 120, 20, Integer.valueOf(sand.carriedBlock.blockId)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ScreenModelViewer.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    if (Blocks.blocksList[id] != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return sand.carriedBlock.blockId;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        blockIdCycle.textField.setPrefaceText("ID: ");
        blockIdCycle.textField.setPlaceholder("Block ID");
        blockIdCycle.setOnValueChanged(() -> {
            sand.carriedBlock.blockId = (Integer)blockIdCycle.getCurrentElement();
        });
        return new ArrayList<ButtonElement>(){
            {
                this.add(blockIdCycle);
            }
        };
    }

    @Override
    public EntityFallingBlock getEntityInstance(Minecraft mc, World world) {
        return new EntityFallingBlock(world);
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

