/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.render.Vertex;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.phys.Vec3;

public class Polygon {
    public Vertex[] vertices;
    public int vertexCount;
    public boolean flipNormal = false;

    public Polygon(Vertex[] vertices) {
        this.vertices = vertices;
        this.vertexCount = vertices.length;
    }

    public Polygon(Vertex[] vertices, int minU, int minV, int maxU, int maxV, int texWidth, int texHeight) {
        this(vertices);
        float offsetU = 0.0015625f;
        float offsetV = 0.003125f;
        vertices[0] = vertices[0].remap((float)maxU / (float)texWidth - offsetU, (float)minV / (float)texHeight + offsetV);
        vertices[1] = vertices[1].remap((float)minU / (float)texWidth + offsetU, (float)minV / (float)texHeight + offsetV);
        vertices[2] = vertices[2].remap((float)minU / (float)texWidth + offsetU, (float)maxV / (float)texHeight - offsetV);
        vertices[3] = vertices[3].remap((float)maxU / (float)texWidth - offsetU, (float)maxV / (float)texHeight - offsetV);
    }

    public void mirror() {
        Vertex[] vertices = new Vertex[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            vertices[i] = this.vertices[this.vertices.length - i - 1];
        }
        this.vertices = vertices;
    }

    public void mirrorU() {
        float minU = this.vertices[1].u;
        float maxU = this.vertices[0].u;
        this.vertices[0].u = minU;
        this.vertices[1].u = maxU;
        this.vertices[2].u = maxU;
        this.vertices[3].u = minU;
    }

    public void mirrorV() {
        float maxV;
        float minV = this.vertices[1].v;
        this.vertices[0].u = maxV = this.vertices[2].v;
        this.vertices[1].u = maxV;
        this.vertices[2].u = minV;
        this.vertices[3].u = minV;
    }

    public void render(Tessellator tessellator, float scale) {
        Vec3 vec3 = this.vertices[1].pos.vectorTo(this.vertices[0].pos);
        Vec3 vec31 = this.vertices[1].pos.vectorTo(this.vertices[2].pos);
        Vec3 vec32 = vec31.crossProduct(vec3).normalize();
        tessellator.startDrawingQuads();
        if (this.flipNormal) {
            tessellator.setNormal(-((float)vec32.x), -((float)vec32.y), -((float)vec32.z));
        } else {
            tessellator.setNormal((float)vec32.x, (float)vec32.y, (float)vec32.z);
        }
        for (int i = 0; i < 4; ++i) {
            Vertex positiontexturevertex = this.vertices[i];
            tessellator.addVertexWithUV((float)positiontexturevertex.pos.x * scale, (float)positiontexturevertex.pos.y * scale, (float)positiontexturevertex.pos.z * scale, positiontexturevertex.u, positiontexturevertex.v);
        }
        tessellator.draw();
    }

    public Polygon flipNormal() {
        this.flipNormal = true;
        return this;
    }
}

