/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;

public class BlockModelPiePumpkin<T extends BlockLogicEdible>
extends BlockModelStandard<T> {
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/pumpkin_pie/side");
    protected IconCoordinate insideTexture = TextureRegistry.getTexture("minecraft:block/pumpkin_pie/inner");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/pumpkin_pie/top");
    public int maxSlices;

    public BlockModelPiePumpkin(Block<T> block) {
        super(block);
        float f = 0.0625f;
        float f1 = 0.375f;
        this.withCustomItemBounds(f, 0.0, f, 1.0f - f, f1, 1.0f - f);
    }

    public void renderSliceSide(Tessellator tessellator, AABB bounds, int x, int y, int z, Side side, boolean overrideTex) {
        if (overrideTex) {
            BlockModelPiePumpkin.renderBlocks.overrideBlockTexture = this.insideTexture;
        }
        this.renderSide(tessellator, bounds, x, y, z, side, 0);
        if (overrideTex) {
            BlockModelPiePumpkin.renderBlocks.overrideBlockTexture = null;
        }
    }

    private void renderSlice(Tessellator tessellator, AABB bounds, int x, int y, int z, int sliceX, int sliceZ) {
        double onePix = 0.0625;
        double sliceWidth = onePix * 8.0;
        double xMin = 0.0 + sliceWidth * (double)sliceX;
        double xMax = xMin + sliceWidth;
        double zMin = 0.0 + sliceWidth * (double)sliceZ;
        double zMax = zMin + sliceWidth;
        double offsetXMin = sliceX == 0 ? onePix : 0.0;
        double offsetXMax = sliceX == 1 ? onePix : 0.0;
        double offsetZMin = sliceZ == 0 ? onePix : 0.0;
        double offsetZMax = sliceZ == 1 ? onePix : 0.0;
        boolean insideSouth = sliceZ == 0;
        boolean insideNorth = sliceZ == 1;
        boolean insideEast = sliceX == 0;
        boolean insideWest = sliceX == 1;
        this.maxSlices = ((BlockLogicEdible)this.block.getLogic()).maxBites;
        bounds.set(xMin + offsetXMin, 0.0, zMin + offsetZMin, xMax - offsetXMax, 0.375, zMax - offsetZMax);
        this.renderSide(tessellator, bounds, x, y, z, Side.TOP, 0);
        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
        this.renderSliceSide(tessellator, bounds, x, y, z, Side.SOUTH, insideSouth);
        this.renderSliceSide(tessellator, bounds, x, y, z, Side.WEST, insideWest);
        BlockModelPiePumpkin.renderBlocks.flipTexture = true;
        this.renderSliceSide(tessellator, bounds, x, y, z, Side.NORTH, insideNorth);
        this.renderSliceSide(tessellator, bounds, x, y, z, Side.EAST, insideEast);
        BlockModelPiePumpkin.renderBlocks.flipTexture = false;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        AABB bounds = this.block.getBlockBoundsFromState(BlockModelPiePumpkin.renderBlocks.blockAccess, x, y, z);
        int meta = BlockModelPiePumpkin.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        BlockModelPiePumpkin.renderBlocks.enableAO = true;
        BlockModelPiePumpkin.renderBlocks.cache.setupCache(this.block, BlockModelPiePumpkin.renderBlocks.blockAccess, x, y, z);
        int slices = 0;
        for (int xSlice = 0; xSlice < 2; ++xSlice) {
            for (int zSlice = 0; zSlice < 2; ++zSlice) {
                if (meta >= ++slices) continue;
                this.renderSlice(tessellator, bounds, x, y, z, xSlice, zSlice);
            }
        }
        BlockModelPiePumpkin.renderBlocks.enableAO = false;
        return true;
    }
}

