/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.entity.Mob;

public abstract class EntityCamera
implements ICamera {
    protected final Minecraft mc;
    private final CameraFrustum frustum;
    public final Mob mob;

    public EntityCamera(Minecraft mc, Mob mob) {
        this.mc = mc;
        this.mob = mob;
        this.frustum = new CameraFrustum(this);
    }

    @Override
    public boolean showPlayer() {
        return false;
    }

    @Override
    public void tick() {
    }

    @Override
    public void applyGlTransformations() {
    }

    @Override
    public double getX(float partialTick) {
        if (partialTick == 1.0f) {
            return this.mob.x;
        }
        return this.mob.xo + (this.mob.x - this.mob.xo) * (double)partialTick;
    }

    @Override
    public double getY(float partialTick) {
        if (partialTick == 1.0f) {
            return this.mob.y;
        }
        return this.mob.yo + (this.mob.y - this.mob.yo) * (double)partialTick;
    }

    @Override
    public double getZ(float partialTick) {
        if (partialTick == 1.0f) {
            return this.mob.z;
        }
        return this.mob.zo + (this.mob.z - this.mob.zo) * (double)partialTick;
    }

    @Override
    public double getXRot(float partialTick) {
        if (partialTick == 1.0f) {
            return this.mob.xRot;
        }
        return this.mob.xRotO + (this.mob.xRot - this.mob.xRotO) * partialTick;
    }

    @Override
    public double getYRot(float partialTick) {
        if (partialTick == 1.0f) {
            return this.mob.yRot;
        }
        return this.mob.yRotO + (this.mob.yRot - this.mob.yRotO) * partialTick;
    }

    @Override
    public double getFov() {
        return ((Float)this.mc.gameSettings.FoV.value).floatValue();
    }

    @Override
    public CameraFrustum getFrustum() {
        return this.frustum;
    }
}

