/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public final class JavaProcess {
    private JavaProcess() {
    }

    public static int exec(Class klass, Collection<String> args) throws IOException, InterruptedException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String className = klass.getName();
        LinkedList<String> command = new LinkedList<String>();
        command.add(javaBin);
        command.add("-cp");
        command.add(classpath);
        command.add(className);
        if (args != null) {
            command.addAll(args);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = builder.inheritIO().start();
        process.waitFor();
        return process.exitValue();
    }
}

