/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.lang.I18n;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;

public abstract class Attribute<T> {
    protected final String key;
    protected final T baseValue;
    protected boolean isDefault = false;
    protected List<Class<? extends Entity>> validFor = new ArrayList<Class<Entity>>(Collections.singleton(Entity.class));

    public Attribute(String key, T defaultValue) {
        this.key = key;
        this.baseValue = defaultValue;
    }

    public Attribute<T> setAsDefault() {
        this.isDefault = true;
        return this;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Attribute<T> setValidEntities(List<Class<? extends Entity>> validFor) {
        this.validFor = validFor;
        return this;
    }

    public List<Class<? extends Entity>> getValidEntities() {
        return this.validFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!Objects.equals(this.key, attribute.key)) {
            return false;
        }
        return Objects.equals(this.baseValue, attribute.baseValue);
    }

    public String toString() {
        return "Attribute{" + this.getName() + ": " + this.baseValue + '}';
    }

    public String getKey() {
        return this.key;
    }

    public T getBaseValue() {
        return this.baseValue;
    }

    public String getName() {
        return I18n.getInstance().translateNameKey(this.key);
    }

    public String getDesc() {
        return I18n.getInstance().translateDescKey(this.key);
    }

    public abstract T calculate(IHasEffects<?> var1);

    public abstract T calculate(IHasEffects<?> var1, T var2);
}

