/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class DoubleAttribute
extends NumberAttribute<Double> {
    public DoubleAttribute(String key, Double defaultValue, Double minValue, Double maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public DoubleAttribute(String key, Double defaultValue) {
        super(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Override
    public Double calculate(IHasEffects<?> target) {
        return this.calculate(target, (Double)this.getBaseValue());
    }

    @Override
    public Double calculate(IHasEffects<?> target, Double baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            double value = baseValue;
            for (Function<IHasEffects<?>, List<Modifier<?>>> function : target.getContainer().additionalModifierSuppliers) {
                List<NumberModifier<Number>> modifiers = this.validateModifiers(function.apply(target));
                for (NumberModifier<Number> modifier : modifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = ((Number)modifier.value).doubleValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.value).doubleValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.value).doubleValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0 * ((Number)modifier.value).doubleValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0 * ((Number)modifier.value).doubleValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.value).doubleValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.value).doubleValue();
                        }
                    }
                }
            }
            List sortedStacks = target.getContainer().getEffects().stream().sorted(Comparator.comparingInt(S -> S.getEffect().getPriority())).collect(Collectors.toList());
            for (EffectStack effectStack : sortedStacks) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                List<NumberModifier<Number>> validModifiers = this.validateModifiers(effectStack.getEffect().getModifiers());
                for (NumberModifier<Number> modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = modifier.calculate(effectStack).doubleValue();
                            break;
                        }
                        case ADD: {
                            value += modifier.calculate(effectStack).doubleValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= modifier.calculate(effectStack).doubleValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0 * modifier.calculate(effectStack).doubleValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0 * modifier.calculate(effectStack).doubleValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= modifier.calculate(effectStack).doubleValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= modifier.calculate(effectStack).doubleValue();
                        }
                    }
                }
            }
            return Math.min((Double)this.maxValue, Math.max(value, (Double)this.minValue));
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

