/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class FloatAttribute
extends NumberAttribute<Float> {
    public FloatAttribute(String key, Float defaultValue, Float minValue, Float maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public FloatAttribute(String key, Float defaultValue) {
        super(key, defaultValue, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    @Override
    public Float calculate(IHasEffects<?> target) {
        return this.calculate(target, (Float)this.getBaseValue());
    }

    @Override
    public Float calculate(IHasEffects<?> target, Float baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            float value = baseValue.floatValue();
            for (Function<IHasEffects<?>, List<Modifier<?>>> function : target.getContainer().additionalModifierSuppliers) {
                List<NumberModifier<Number>> modifiers = this.validateModifiers(function.apply(target));
                for (NumberModifier<Number> modifier : modifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = ((Number)modifier.value).floatValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.value).floatValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.value).floatValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0f * ((Number)modifier.value).floatValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0f * ((Number)modifier.value).floatValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.value).floatValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.value).floatValue();
                        }
                    }
                }
            }
            List sortedStacks = target.getContainer().getEffects().stream().sorted(Comparator.comparingInt(S -> S.getEffect().getPriority())).collect(Collectors.toList());
            for (EffectStack effectStack : sortedStacks) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                List<NumberModifier<Number>> validModifiers = this.validateModifiers(effectStack.getEffect().getModifiers());
                for (NumberModifier<Number> modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = modifier.calculate(effectStack).floatValue();
                            break;
                        }
                        case ADD: {
                            value += modifier.calculate(effectStack).floatValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= modifier.calculate(effectStack).floatValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0f * modifier.calculate(effectStack).floatValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0f * modifier.calculate(effectStack).floatValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= modifier.calculate(effectStack).floatValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= modifier.calculate(effectStack).floatValue();
                        }
                    }
                }
            }
            return Float.valueOf(Math.min(((Float)this.maxValue).floatValue(), Math.max(value, ((Float)this.minValue).floatValue())));
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

