/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class IntAttribute
extends NumberAttribute<Integer> {
    public IntAttribute(String key, Integer defaultValue, Integer minValue, Integer maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public IntAttribute(String key, Integer defaultValue) {
        super(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Integer calculate(IHasEffects<?> target) {
        return this.calculate(target, (Integer)this.getBaseValue());
    }

    @Override
    public Integer calculate(IHasEffects<?> target, Integer baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            int value = baseValue;
            for (Function<IHasEffects<?>, List<Modifier<?>>> function : target.getContainer().additionalModifierSuppliers) {
                List<NumberModifier<Number>> modifiers = this.validateModifiers(function.apply(target));
                for (NumberModifier<Number> modifier : modifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = ((Number)modifier.value).intValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.value).intValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.value).intValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100 * ((Number)modifier.value).intValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100 * ((Number)modifier.value).intValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.value).intValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.value).intValue();
                        }
                    }
                }
            }
            List sortedStacks = target.getContainer().getEffects().stream().sorted(Comparator.comparingInt(S -> S.getEffect().getPriority())).collect(Collectors.toList());
            for (EffectStack effectStack : sortedStacks) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                List<NumberModifier<Number>> validModifiers = this.validateModifiers(effectStack.getEffect().getModifiers());
                for (NumberModifier<Number> modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = modifier.calculate(effectStack).intValue();
                            break;
                        }
                        case ADD: {
                            value += modifier.calculate(effectStack).intValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= modifier.calculate(effectStack).intValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100 * modifier.calculate(effectStack).intValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100 * modifier.calculate(effectStack).intValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= modifier.calculate(effectStack).intValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= modifier.calculate(effectStack).intValue();
                        }
                    }
                }
            }
            return Math.min((Integer)this.maxValue, Math.max(value, (Integer)this.minValue));
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

