/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class LongAttribute
extends NumberAttribute<Long> {
    public LongAttribute(String key, Long defaultValue, Long minValue, Long maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public LongAttribute(String key, Long defaultValue) {
        super(key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public Long calculate(IHasEffects<?> target) {
        return this.calculate(target, (Long)this.getBaseValue());
    }

    @Override
    public Long calculate(IHasEffects<?> target, Long baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            long value = baseValue;
            for (Function<IHasEffects<?>, List<Modifier<?>>> function : target.getContainer().additionalModifierSuppliers) {
                List<NumberModifier<Number>> modifiers = this.validateModifiers(function.apply(target));
                for (NumberModifier<Number> modifier : modifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = ((Number)modifier.value).longValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.value).longValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.value).longValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100L * ((Number)modifier.value).longValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100L * ((Number)modifier.value).longValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.value).longValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.value).longValue();
                        }
                    }
                }
            }
            List sortedStacks = target.getContainer().getEffects().stream().sorted(Comparator.comparingInt(S -> S.getEffect().getPriority())).collect(Collectors.toList());
            for (EffectStack effectStack : sortedStacks) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                List<NumberModifier<Number>> validModifiers = this.validateModifiers(effectStack.getEffect().getModifiers());
                for (NumberModifier<Number> modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            value = modifier.calculate(effectStack).longValue();
                            break;
                        }
                        case ADD: {
                            value += modifier.calculate(effectStack).longValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= modifier.calculate(effectStack).longValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100L * modifier.calculate(effectStack).longValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100L * modifier.calculate(effectStack).longValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= modifier.calculate(effectStack).longValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= modifier.calculate(effectStack).longValue();
                        }
                    }
                }
            }
            return Math.min((Long)this.maxValue, Math.max(value, (Long)this.minValue));
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

