/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import sunsetsatellite.catalyst.effects.api.attribute.Attribute;
import sunsetsatellite.catalyst.effects.api.attribute.Attributes;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.Effects;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import sunsetsatellite.catalyst.effects.net.SyncEffectContainerForEntityNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class EffectStack {
    private final Effect effect;
    private final int duration;
    private int timeLeft;
    private int amount;
    private State state = State.INACTIVE;

    public EffectStack(IHasEffects target, Effect effect) {
        this.effect = effect;
        this.duration = Attributes.EFFECT_DURATION.calculate(target, effect.getDefaultDuration());
        this.amount = 1;
    }

    public EffectStack(IHasEffects target, Effect effect, int amount) {
        this.effect = effect;
        this.duration = Attributes.EFFECT_DURATION.calculate(target, effect.getDefaultDuration());
        this.amount = Math.min(amount, effect.getMaxStack());
    }

    public EffectStack(IHasEffects target, Effect effect, int duration, int amount) {
        this.effect = effect;
        this.duration = Attributes.EFFECT_DURATION.calculate(target, duration);
        this.amount = Math.min(amount, effect.getMaxStack());
    }

    public EffectStack(CompoundTag tag) {
        this.effect = (Effect)Effects.getInstance().getItem(tag.getString("id"));
        this.duration = tag.getInteger("duration");
        this.amount = tag.getInteger("amount");
        this.state = State.valueOf(tag.getString("state"));
        this.timeLeft = tag.getInteger("timeLeft");
    }

    public <T> void start(EffectContainer<T> container) {
        if (this.state == State.INACTIVE) {
            this.state = State.ACTIVE;
            this.timeLeft = this.duration;
            this.effect.activated(this, container);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)container.getParent()));
            }
        }
    }

    public <T> void pause(EffectContainer<T> container) {
        if (this.state == State.ACTIVE) {
            this.state = State.PAUSED;
            this.effect.paused(this, container);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)container.getParent()));
            }
        }
    }

    public <T> void unpause(EffectContainer<T> container) {
        if (this.state == State.PAUSED) {
            this.state = State.ACTIVE;
            this.effect.unpaused(this, container);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)container.getParent()));
            }
        }
    }

    public <T> void finish(EffectContainer<T> effectContainer) {
        if (this.state == State.ACTIVE) {
            this.timeLeft = 0;
            this.state = State.FINISHED;
            this.effect.expired(this, effectContainer);
        }
    }

    public <T> void tick(EffectContainer<T> effectContainer) {
        if (this.state == State.ACTIVE) {
            if (this.effect.getTimeType() == EffectTimeType.PERMANENT) {
                this.effect.tick(this, effectContainer);
                return;
            }
            if (this.timeLeft > 0) {
                --this.timeLeft;
                this.effect.tick(this, effectContainer);
            } else {
                this.finish(effectContainer);
            }
        }
    }

    public <T> void add(int amount, EffectContainer<T> effectContainer) {
        this.amount += amount;
        if (this.effect.getTimeType() == EffectTimeType.RESET) {
            this.timeLeft = this.duration;
        }
        if (this.effect.getTimeType() == EffectTimeType.ADD) {
            this.timeLeft += this.effect.getDurationIncrease();
        }
        this.effect.stackAdded(this, effectContainer);
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)effectContainer.getParent()));
        }
    }

    public <T> void subtract(int amount, EffectContainer<T> effectContainer) {
        this.amount -= amount;
        this.effect.stackSubtracted(this, effectContainer);
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)effectContainer.getParent()));
        }
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public int getAmount() {
        return this.amount;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean hasAttribute(Attribute<?> attribute) {
        for (Modifier<?> modifier : this.effect.getModifiers()) {
            if (!modifier.attribute.equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public void saveToNbt(CompoundTag tag) {
        tag.putString("id", this.effect.id);
        tag.putInt("duration", this.duration);
        tag.putInt("timeLeft", this.timeLeft);
        tag.putInt("amount", this.amount);
        tag.putString("state", this.state.name());
    }

    public static enum State {
        INACTIVE,
        ACTIVE,
        PAUSED,
        FINISHED;

    }
}

