/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;

public class EffectTagDispatcher {
    private static final HashMap<Class<? extends IHasEffects<?>>, Set<Tag<Effect>>> immunityMap = new HashMap();
    private static final HashMap<Class<? extends IHasEffects<?>>, Set<Tag<Effect>>> removedImmunityMap = new HashMap();

    protected EffectTagDispatcher() {
    }

    @NotNull
    public static Set<Tag<Effect>> getImmunitiesFor(Class<? extends Entity> holder) {
        HashSet<Tag<Effect>> tags = new HashSet<Tag<Effect>>();
        List<Class<IHasEffects<?>>> classList = EffectTagDispatcher.findGrandpa(holder);
        for (int i = classList.size() - 1; i >= 0; --i) {
            Set<Tag<Effect>> superTags = immunityMap.get(classList.get(i));
            Set<Tag<Effect>> removedSuperTags = removedImmunityMap.get(classList.get(i));
            if (superTags != null) {
                tags.addAll(superTags);
            }
            if (removedSuperTags == null) continue;
            for (Tag<Effect> tag : removedSuperTags) {
                tags.remove(tag);
            }
        }
        return tags;
    }

    private static List<Class<? extends IHasEffects<?>>> findGrandpa(Class<? extends IHasEffects<?>> target) {
        ArrayList list = new ArrayList();
        Class<IHasEffects<?>> clazz = target;
        while (IHasEffects.class.isAssignableFrom(clazz)) {
            list.add(clazz);
            Class<IHasEffects<?>> zuper = clazz.getSuperclass();
            if (!IHasEffects.class.isAssignableFrom(zuper)) break;
            clazz = zuper;
        }
        return list;
    }

    @SafeVarargs
    public static void setImmunityFor(Class<? extends Entity> clazz, Tag<Effect> ... tags) {
        Set immunities = immunityMap.computeIfAbsent(clazz, n -> new HashSet());
        Set removedImmunities = removedImmunityMap.computeIfAbsent(clazz, n -> new HashSet());
        for (Tag<Effect> tag : tags) {
            immunities.add(tag);
            removedImmunities.remove(tag);
        }
    }

    @SafeVarargs
    public static void removeImmunityFor(Class<? extends Entity> clazz, Tag<Effect> ... tags) {
        Set immunities = immunityMap.computeIfAbsent(clazz, n -> new HashSet());
        Set removedImmunities = removedImmunityMap.computeIfAbsent(clazz, n -> new HashSet());
        for (Tag<Effect> tag : tags) {
            if (immunities.contains(tag)) {
                immunities.remove(tag);
                continue;
            }
            removedImmunities.add(tag);
        }
    }
}

