/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRenderer;

public class TintEffectRender<T extends Effect>
extends EffectRenderer<T> {
    private final String vignette;
    private final int tint;

    public TintEffectRender(T effect, String vignette, int tint) {
        super(effect);
        this.vignette = vignette;
        this.tint = tint;
    }

    @Override
    public boolean shouldDisplayScreenEffect() {
        return true;
    }

    @Override
    void drawScreenEffect(Minecraft minecraft, Gui gui, EffectStack stack, int width, int height, float partialTick) {
        float alpha = this.calcAlpha(stack);
        if (!((Boolean)Minecraft.getMinecraft().gameSettings.vignette.value).booleanValue() || this.vignette == null || this.vignette.isEmpty()) {
            this.drawTint(width, height, this.tint, alpha);
        } else {
            this.drawVignette(width, height, this.vignette, alpha);
        }
    }

    private void drawTint(int width, int height, int tint, float alpha) {
        Tessellator tessellator = Tessellator.instance;
        float r = (float)(tint >> 16 & 0xFF) / 255.0f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f;
        float b = (float)(tint & 0xFF) / 255.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
        tessellator.startDrawingQuads();
        tessellator.addVertex(0.0, (double)height, 0.0);
        tessellator.addVertex((double)width, (double)height, 0.0);
        tessellator.addVertex((double)width, 0.0, 0.0);
        tessellator.addVertex(0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawVignette(int width, int height, String vignette, float alpha) {
        TextureManager textureManager = Minecraft.getMinecraft().textureManager;
        Tessellator tessellator = Tessellator.instance;
        GL11.glPushMatrix();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        textureManager.bindTexture(textureManager.loadTexture(vignette));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int z = -1;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, 0.0, (double)z, 0.0, 0.0);
        tessellator.addVertexWithUV(0.0, (double)height, (double)z, 0.0, 1.0);
        tessellator.addVertexWithUV((double)width, (double)height, (double)z, 1.0, 1.0);
        tessellator.addVertexWithUV((double)width, 0.0, (double)z, 1.0, 0.0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    public float calcAlpha(EffectStack effectStack) {
        float currentAmount = (float)effectStack.getDuration() * (float)(effectStack.getAmount() - 1);
        float totalTime = (float)effectStack.getDuration() * (float)effectStack.getEffect().getMaxStack();
        return (currentAmount + (float)effectStack.getTimeLeft()) / totalTime;
    }
}

