/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect.render.heartContainer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.player.Player;

@Environment(value=EnvType.CLIENT)
public class HeartContainer {
    protected final Player player;

    public HeartContainer(Player player) {
        this.player = player;
    }

    public String getBasePath() {
        return "minecraft:gui/hud/heart/";
    }

    public String getPathForGlyph(HeartGlyphVariant glyphVariant, HeartGlyphType glyphType) {
        if (glyphType == HeartGlyphType.CONTAINER) {
            return this.getBasePath() + glyphType.name + (this.isHeartFlashing() ? "_blinking" : "");
        }
        String prefix = glyphVariant != HeartGlyphVariant.NONE ? glyphVariant.name + "_" : "";
        return this.getBasePath() + prefix + glyphType.name + (this.isHeartFlashing() ? "_blinking" : "");
    }

    public void drawHeart(HeartGlyphVariant variant, HeartGlyphType glyphType, int x, int y, HudIngame hud) {
        hud.drawGuiIcon(x, y, 9, 9, TextureRegistry.getTexture((String)this.getPathForGlyph(variant, glyphType)));
    }

    public boolean isHeartFlashing() {
        boolean heartsFlash;
        boolean bl = heartsFlash = this.player.heartsFlashTime / 3 % 2 == 1;
        if (this.player.heartsFlashTime < 10) {
            heartsFlash = false;
        }
        return heartsFlash;
    }

    public boolean shouldShake() {
        return this.player.getHealth() < 4 || this.isHeartFlashing();
    }

    public static enum HeartGlyphType {
        FULL("full"),
        HALF("half"),
        HALF_RIGHT("half_right"),
        CONTAINER("container");

        private final String name;

        private HeartGlyphType(String colorName) {
            this.name = colorName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum HeartGlyphVariant {
        NONE(""),
        HARDCORE("hardcore"),
        PREVIEW("preview"),
        OVERHEAL("overheal");

        private final String name;

        private HeartGlyphVariant(String colorName) {
            this.name = colorName;
        }

        public String getName() {
            return this.name;
        }
    }
}

