/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.helpers.EntitySelector;
import org.useless.seedviewer.collections.NamespaceID;
import sunsetsatellite.catalyst.CatalystEffects;
import sunsetsatellite.catalyst.effects.api.attribute.Attribute;
import sunsetsatellite.catalyst.effects.api.attribute.Attributes;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.command.argument.ArgumentTypeAttribute;

public class CommandAttributes
implements CommandManager.CommandRegistry {
    public static void listAttributes(CommandContext<CommandSource> ctx, IHasEffects target) {
        Attributes attrs = Attributes.getInstance();
        HashMap<String, List> attrByMod = new HashMap<String, List>();
        Iterator iterator = Attributes.getInstance().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            List list = attrByMod.computeIfAbsent(new NamespaceID((String)attrs.getKey((Object)attribute)).namespace, k -> new ArrayList());
            list.add(attribute);
        }
        CommandSource source = (CommandSource)ctx.getSource();
        for (String key : attrByMod.keySet()) {
            List attributes = (List)attrByMod.get(key);
            if (attributes == null) continue;
            source.sendMessage("  " + TextFormatting.YELLOW + TextFormatting.BOLD + "@" + key + TextFormatting.RESET);
            for (Attribute attribute : attributes) {
                source.sendMessage(String.format("- %s: %s", new NamespaceID((String)attrs.getKey((Object)attribute)).value, attribute.calculate(target)));
            }
        }
    }

    public static int listAttributesForSender(CommandContext<CommandSource> ctx) {
        ((CommandSource)ctx.getSource()).sendMessage("Available attributes:");
        CommandAttributes.listAttributes(ctx, (IHasEffects)((CommandSource)ctx.getSource()).getSender());
        return 1;
    }

    public static int listAttributesForTarget(CommandContext<CommandSource> ctx) {
        EntitySelector entitySelector = (EntitySelector)ctx.getArgument("target", EntitySelector.class);
        try {
            List entities = entitySelector.get((CommandSource)ctx.getSource());
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = (Entity)entities.get(i);
                ((CommandSource)ctx.getSource()).sendMessage(String.format("Available attributes for %s:", TextFormatting.get((int)(entity instanceof Mob ? (int)((Mob)entity).chatColor : 0)).toString() + TextFormatting.BOLD + Entity.getNameFromEntity((Entity)entity, (boolean)true) + TextFormatting.RESET));
                CommandAttributes.listAttributes(ctx, (IHasEffects)entity);
                if (i >= entities.size() - 1) continue;
                ((CommandSource)ctx.getSource()).sendMessage(" ");
            }
        }
        catch (CommandSyntaxException e) {
            CatalystEffects.LOGGER.info(String.valueOf((Object)e));
            throw new RuntimeException(e);
        }
        return 1;
    }

    public static int getAttribute(CommandContext<CommandSource> ctx) {
        Attribute attr = (Attribute)ctx.getArgument("attribute", Attribute.class);
        CommandSource source = (CommandSource)ctx.getSource();
        Player player = Objects.requireNonNull(source.getSender());
        source.sendMessage("Current value for \"" + attr.getName() + "\": ");
        source.sendMessage(String.format("%s : %s", Entity.getNameFromEntity((Entity)player, (boolean)true), attr.calculate((IHasEffects)player)));
        return 1;
    }

    public static int getAttributeForTarget(CommandContext<CommandSource> ctx) {
        Attribute attr = (Attribute)ctx.getArgument("attribute", Attribute.class);
        EntitySelector entitySelector = (EntitySelector)ctx.getArgument("target", EntitySelector.class);
        CommandSource source = (CommandSource)ctx.getSource();
        try {
            List entities = entitySelector.get(source);
            source.sendMessage("Current value for \"" + attr.getName() + "\": ");
            for (Entity entity : entities) {
                source.sendMessage(Entity.getNameFromEntity((Entity)entity, (boolean)true) + TextFormatting.RESET + ": " + attr.calculate((IHasEffects)entity));
            }
        }
        catch (CommandSyntaxException e) {
            CatalystEffects.LOGGER.info(String.valueOf((Object)e));
            throw new RuntimeException(e);
        }
        return 1;
    }

    public void register(CommandDispatcher<CommandSource> commandDispatcher) {
        ArgumentBuilderLiteral attributes = (ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"attribute").then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"list").then(ArgumentBuilderRequired.argument((String)"target", (ArgumentType)ArgumentTypeEntity.entities()).executes(CommandAttributes::listAttributesForTarget))).executes(CommandAttributes::listAttributesForSender))).then(ArgumentBuilderLiteral.literal((String)"get").then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument((String)"attribute", ArgumentTypeAttribute.attribute()).then(ArgumentBuilderRequired.argument((String)"target", (ArgumentType)ArgumentTypeEntity.entities()).executes(CommandAttributes::getAttributeForTarget))).executes(CommandAttributes::getAttribute)));
        commandDispatcher.register(attributes);
    }
}

