/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.net;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Optional;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.CatalystEffects;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class SyncEffectContainerForEntityNetworkMessage
implements NetworkMessage {
    private int entityID;
    private EffectContainer<?> container;
    private CompoundTag containerNBT;

    public SyncEffectContainerForEntityNetworkMessage() {
    }

    public SyncEffectContainerForEntityNetworkMessage(Entity entity) {
        this.entityID = entity.id;
        this.container = ((IHasEffects)entity).getContainer();
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.entityID);
        CompoundTag containerNBT = new CompoundTag();
        this.container.saveToNbt(containerNBT);
        packet.writeCompoundTag(containerNBT);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.entityID = packet.readInt();
        this.containerNBT = packet.readCompoundTag();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (EnvironmentHelper.isServerEnvironment()) {
            return;
        }
        World world = context.player.world;
        if (world == null) {
            CatalystEffects.LOGGER.error("Couldn't syncronize entity effects for {}! Is the world real?", (Object)this.entityID);
            return;
        }
        Optional<Entity> entityOption = world.getLoadedEntityList().stream().filter(e -> e.id == this.entityID).findFirst();
        if (!entityOption.isPresent()) {
            CatalystEffects.LOGGER.error("Couldn't syncronize entity effects for {}! Entity isn't present", (Object)this.entityID);
            return;
        }
        EffectContainer container = ((IHasEffects)entityOption.get()).getContainer();
        container.removeAll();
        container.loadFromNbt(this.containerNBT);
    }
}

