package teamport.aether.mixin.accessory.trinket;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import teamport.aether.items.AetherItems;

import static teamport.aether.items.accessory.SlotAccessory.TRINKET_1_SLOT;
import static teamport.aether.items.accessory.SlotAccessory.TRINKET_2_SLOT;

@Mixin(value = ContainerInventory.class, remap = false)
public abstract class ContainerInventoryZanitePendantDamageMixin {
    @Shadow
    public ItemStack[] mainInventory;
    @Shadow
    public Player player;
    @ModifyReturnValue(method = "getDamageVsEntity", at = @At("RETURN"))
    private int getGloveDamage(int damage) {
        ItemStack trinketOne = player.inventory.armorInventory[TRINKET_1_SLOT];
        ItemStack trinketTwo = player.inventory.armorInventory[TRINKET_2_SLOT];
        if (trinketOne != null && trinketOne.itemID == AetherItems.ARMOR_TALISMAN_ZANITE.id) {
            damage = addDamage(damage, trinketOne);
        }
        if (trinketTwo != null && trinketTwo.itemID == AetherItems.ARMOR_TALISMAN_ZANITE.id) {
            damage = addDamage(damage, trinketTwo);
        }
        return damage;
    }
    @Unique
    private int addDamage(int damage, ItemStack trinketOne) {
        float damagePercent = (float) trinketOne.getMetadata() / trinketOne.getMaxDamage();
        float speed = MathHelper.lerp(0.0F, 3.0F, damagePercent);
        trinketOne.damageItem(1, player);
        damage += (int) Math.floor(speed);
        return damage;
    }
}
