package teamport.aether.mixin.player;

import net.minecraft.core.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value = Player.class, remap = false)
public abstract class PlayerFixArmorMixin {
    @ModifyArg(method = "damageEntity(ILnet/minecraft/core/util/helper/DamageType;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/core/player/inventory/container/ContainerInventory;damageArmor(I)V"), index = 0)
    private int forceMinArmorWearOnNegation(int amount) {
        return Math.max(amount, 1);
    }
}
