/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.achievements;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.achievements.data.AchievementPage;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Color;
import org.jspecify.annotations.NonNull;
import teamport.aether.achievements.AetherAchievementPageBackground;
import teamport.aether.achievements.AetherAchievementPageExtras;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.helper.unboxed.IntPair;

@Environment(value=EnvType.CLIENT)
public class AchievementPageAether
extends AchievementPage
implements AetherAchievementPageExtras {
    public final String name;
    public final ItemStack icon;
    private static final IconCoordinate WATER_FLOWING;
    private static final @NonNull IconCoordinate AETHER_GRASS;
    private static final @NonNull IconCoordinate COBBLED_HOLYSTONE;
    private static final @NonNull IconCoordinate COBBLED_HOLYSTONE_MOSSY;
    private static final @NonNull IconCoordinate AETHER_DIRT;
    private static final @NonNull IconCoordinate QUICKSOIL;
    private static final @NonNull IconCoordinate LOG_SKYROOT;
    private static final @NonNull IconCoordinate LEAVES_SKYROOT;
    private static final @NonNull IconCoordinate BLUE_CLOUD;
    private static final @NonNull IconCoordinate YELLOW_CLOUD;
    private static final @NonNull IconCoordinate CLOUD;
    private static final @NonNull IconCoordinate AETHER_TALL_GRASS;
    private static final @NonNull IconCoordinate WHITE_FLOWER;
    private static final @NonNull IconCoordinate PURPLE_FLOWER;
    private static final @NonNull IconCoordinate LEAVES_GOLDEN;
    private static final @NonNull IconCoordinate LOG_GOLDEN;
    private static final @NonNull IconCoordinate AMBROSIUM;
    private static final @NonNull IconCoordinate GRAVITITE;
    private static final @NonNull IconCoordinate ICE_STONE;
    private static final @NonNull IconCoordinate SLIDER_TOP_LEFT;
    private static final @NonNull IconCoordinate SLIDER_BOTTOM_LEFT;
    private static final @NonNull IconCoordinate SLIDER_TOP_RIGHT;
    private static final @NonNull IconCoordinate SLIDER_BOTTOM_RIGHT;
    private static final IconCoordinate[] TERRAIN_MAP;
    private static final AetherAchievementPageBackground BACKGROUND;
    private static final IconCoordinate SENTRY_STONE;
    private static final IconCoordinate SENTRY_STONE_LIGHT;

    public AchievementPageAether(String name, ItemStack icon) {
        this.name = name;
        this.icon = icon;
    }

    public void postProcessBackground(ScreenAchievements screen, Random random, ScreenAchievements.BGLayer bGLayer, int i, int j) {
    }

    public IconCoordinate getBackgroundTile(ScreenAchievements screen, int layer, Random random, int tileX, int tileY) {
        List<Integer> row;
        int origY = tileY += 15;
        if ((tileX += 50) < 0) {
            tileX += AchievementPageAether.BACKGROUND.width;
        }
        if (tileY < 0) {
            tileY += AchievementPageAether.BACKGROUND.height;
        }
        tileX = Math.abs(tileX % AchievementPageAether.BACKGROUND.width);
        tileY = Math.abs(tileY % AchievementPageAether.BACKGROUND.height);
        List<List<Integer>> structLayer = null;
        if (layer == 0 && origY > 0) {
            List<IntPair> water = AchievementPageAether.BACKGROUND.waterSources;
            for (IntPair w : water) {
                if (w.getFirst() != tileX || w.getSecond() > origY) continue;
                return WATER_FLOWING;
            }
        }
        if (layer == 3 && (row = (structLayer = AchievementPageAether.BACKGROUND.specials).get(tileY)).get(tileX) == 2) {
            boolean left;
            List<Integer> upperRow = structLayer.get(tileY + 1);
            boolean upper = upperRow.get(tileX) == 2;
            boolean bl = left = row.get(tileX - 1) == 2;
            if (!upper) {
                if (left) {
                    return SLIDER_BOTTOM_RIGHT;
                }
                return SLIDER_BOTTOM_LEFT;
            }
            if (left) {
                return SLIDER_TOP_RIGHT;
            }
            return SLIDER_TOP_LEFT;
        }
        if (layer == 1) {
            structLayer = AchievementPageAether.BACKGROUND.terrainLayer1;
        }
        if (layer == 2) {
            structLayer = AchievementPageAether.BACKGROUND.terrainLayer2;
        }
        if (layer == 3) {
            structLayer = AchievementPageAether.BACKGROUND.terrainLayer3;
        }
        if (layer == 4) {
            structLayer = AchievementPageAether.BACKGROUND.terrainLayer4;
        }
        if (structLayer == null) {
            return null;
        }
        row = structLayer.get(tileY);
        int col = row.get(tileX);
        return TERRAIN_MAP[col];
    }

    public @NonNull ItemStack getIcon() {
        return this.icon;
    }

    public int backgroundLayers() {
        return 5;
    }

    public int backgroundColor() {
        return -5197577;
    }

    public IconCoordinate getAchievementIcon(Achievement achievement) {
        return TextureRegistry.getTexture((String)achievement.getType().texture);
    }

    public int lineColorLocked(boolean bl) {
        return 0;
    }

    public int lineColorUnlocked(boolean bl) {
        return 0x707070;
    }

    public int lineColorCanUnlock(boolean bl) {
        return 65280;
    }

    public @NonNull String getName() {
        return I18n.getInstance().translateNameKey(this.name);
    }

    public @NonNull String getDescription() {
        return I18n.getInstance().translateNameKey(this.name);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AchievementPage.AchievementEntry onOpenAchievement() {
        return Objects.requireNonNull(this.getEntry(AetherAchievements.HOSTILE_PARADISE));
    }

    @Override
    public float getShadowScale(int layer) {
        if (layer == 3) {
            return 1.7f;
        }
        if (layer == 2) {
            return 1.3f;
        }
        return 1.0f;
    }

    public static int mixColor(int colorA, int colorB, float ratio) {
        int alphaA = Color.alphaFromInt((int)colorA);
        int redA = Color.redFromInt((int)colorA);
        int blueA = Color.blueFromInt((int)colorA);
        int greenA = Color.greenFromInt((int)colorA);
        int alphaB = Color.alphaFromInt((int)colorB);
        int redB = Color.redFromInt((int)colorB);
        int blueB = Color.blueFromInt((int)colorB);
        int greenB = Color.greenFromInt((int)colorB);
        int alphaRes = (int)((float)alphaA * ratio + (float)alphaB * (1.0f - ratio));
        int redRes = (int)((float)redA * ratio + (float)redB * (1.0f - ratio));
        int blueRes = (int)((float)blueA * ratio + (float)blueB * (1.0f - ratio));
        int greenRes = (int)((float)greenA * ratio + (float)greenB * (1.0f - ratio));
        return Color.intToIntARGB((int)alphaRes, (int)redRes, (int)greenRes, (int)blueRes);
    }

    @Override
    public void drawBeforeTiles(ScreenAchievements gui, double shiftX, double shiftY, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        double shiftYAdjusted = (Math.floor(shiftY) + 288.0) / 576.0;
        int bottomTop = -8818486;
        int bottomBottom = -11448471;
        int colorBottom = AchievementPageAether.mixColor(bottomBottom, bottomTop, (float)shiftYAdjusted);
        gui.drawGradientRect(left, top, right, bottom, this.backgroundColor(), colorBottom);
    }

    static {
        BACKGROUND = new AetherAchievementPageBackground();
        IconCoordinate water = TextureRegistry.getTexture((String)"aether:block/jank/water_flow");
        WATER_FLOWING = new IconCoordinate(water.parentAtlas, water.namespaceId, water.getImageSource());
        WATER_FLOWING.setDimension(water.width / 2, water.height / 2);
        WATER_FLOWING.setPosition(water.iconX, water.iconY);
        AETHER_GRASS = TextureRegistry.getTexture((String)"aether:block/grass_aether/side");
        AETHER_DIRT = TextureRegistry.getTexture((String)"aether:block/dirt_aether");
        COBBLED_HOLYSTONE = TextureRegistry.getTexture((String)"aether:block/cobbled_holystone");
        COBBLED_HOLYSTONE_MOSSY = TextureRegistry.getTexture((String)"aether:block/cobbled_holystone_mossy");
        QUICKSOIL = TextureRegistry.getTexture((String)"aether:block/quicksoil");
        LOG_SKYROOT = TextureRegistry.getTexture((String)"aether:block/log/skyroot_side");
        LEAVES_SKYROOT = TextureRegistry.getTexture((String)"aether:block/leaves/skyroot");
        LEAVES_GOLDEN = TextureRegistry.getTexture((String)"aether:block/leaves/oak_golden");
        LOG_GOLDEN = TextureRegistry.getTexture((String)"aether:block/log/oak_golden_side");
        BLUE_CLOUD = TextureRegistry.getTexture((String)"aether:block/aercloud_blue");
        YELLOW_CLOUD = TextureRegistry.getTexture((String)"aether:block/aercloud_gold");
        CLOUD = TextureRegistry.getTexture((String)"aether:block/aercloud_white");
        AETHER_TALL_GRASS = TextureRegistry.getTexture((String)"aether:block/tallgrass_aether");
        WHITE_FLOWER = TextureRegistry.getTexture((String)"aether:block/flower_white/0");
        PURPLE_FLOWER = TextureRegistry.getTexture((String)"aether:block/flower_purple/0");
        SENTRY_STONE = TextureRegistry.getTexture((String)"aether:block/dungeon/carved");
        SENTRY_STONE_LIGHT = TextureRegistry.getTexture((String)"aether:block/dungeon/carved_glow");
        AMBROSIUM = TextureRegistry.getTexture((String)"aether:block/ore/ambrosium/holystone");
        GRAVITITE = TextureRegistry.getTexture((String)"aether:block/ore/gravitite/holystone");
        ICE_STONE = TextureRegistry.getTexture((String)"aether:block/icestone");
        IconCoordinate sliderSheet = TextureRegistry.getTexture((String)"aether:block/jank/slider");
        SLIDER_TOP_LEFT = new IconCoordinate(sliderSheet.parentAtlas, sliderSheet.namespaceId, sliderSheet.getImageSource());
        SLIDER_BOTTOM_LEFT = new IconCoordinate(sliderSheet.parentAtlas, sliderSheet.namespaceId, sliderSheet.getImageSource());
        SLIDER_TOP_RIGHT = new IconCoordinate(sliderSheet.parentAtlas, sliderSheet.namespaceId, sliderSheet.getImageSource());
        SLIDER_BOTTOM_RIGHT = new IconCoordinate(sliderSheet.parentAtlas, sliderSheet.namespaceId, sliderSheet.getImageSource());
        SLIDER_TOP_LEFT.setDimension(16, 16);
        SLIDER_BOTTOM_LEFT.setDimension(16, 16);
        SLIDER_TOP_RIGHT.setDimension(16, 16);
        SLIDER_BOTTOM_RIGHT.setDimension(16, 16);
        SLIDER_TOP_LEFT.setPosition(sliderSheet.iconX, sliderSheet.iconY);
        SLIDER_BOTTOM_LEFT.setPosition(sliderSheet.iconX, sliderSheet.iconY + 16);
        SLIDER_TOP_RIGHT.setPosition(sliderSheet.iconX + 16, sliderSheet.iconY);
        SLIDER_BOTTOM_RIGHT.setPosition(sliderSheet.iconX + 16, sliderSheet.iconY + 16);
        TERRAIN_MAP = new IconCoordinate[21];
        AchievementPageAether.TERRAIN_MAP[0] = null;
        AchievementPageAether.TERRAIN_MAP[8] = AETHER_TALL_GRASS;
        AchievementPageAether.TERRAIN_MAP[3] = AETHER_GRASS;
        AchievementPageAether.TERRAIN_MAP[2] = AETHER_DIRT;
        AchievementPageAether.TERRAIN_MAP[1] = COBBLED_HOLYSTONE;
        AchievementPageAether.TERRAIN_MAP[4] = COBBLED_HOLYSTONE_MOSSY;
        AchievementPageAether.TERRAIN_MAP[5] = QUICKSOIL;
        AchievementPageAether.TERRAIN_MAP[6] = LOG_SKYROOT;
        AchievementPageAether.TERRAIN_MAP[7] = LEAVES_SKYROOT;
        AchievementPageAether.TERRAIN_MAP[9] = WHITE_FLOWER;
        AchievementPageAether.TERRAIN_MAP[10] = PURPLE_FLOWER;
        AchievementPageAether.TERRAIN_MAP[11] = LEAVES_GOLDEN;
        AchievementPageAether.TERRAIN_MAP[12] = LOG_GOLDEN;
        AchievementPageAether.TERRAIN_MAP[13] = BLUE_CLOUD;
        AchievementPageAether.TERRAIN_MAP[14] = YELLOW_CLOUD;
        AchievementPageAether.TERRAIN_MAP[15] = CLOUD;
        AchievementPageAether.TERRAIN_MAP[16] = SENTRY_STONE;
        AchievementPageAether.TERRAIN_MAP[17] = SENTRY_STONE_LIGHT;
        AchievementPageAether.TERRAIN_MAP[18] = AMBROSIUM;
        AchievementPageAether.TERRAIN_MAP[19] = GRAVITITE;
        AchievementPageAether.TERRAIN_MAP[20] = ICE_STONE;
    }
}

