/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.dungeon;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import teamport.aether.blocks.dungeon.BlockLogicDungeon;

public class BlockLogicLocked
extends BlockLogicDungeon {
    public final Block<?> replacement;

    public BlockLogicLocked(Block<?> block, Material material, Block<?> replacement) {
        super(block, material);
        this.replacement = replacement;
    }

    public int tickDelay() {
        return 1200;
    }

    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        this.attemptPropagate(world, x, y, z);
    }

    public @Nullable ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this.replacement, 1)};
        }
        return null;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.attemptPropagate(world, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.attemptPropagate(world, x, y, z);
    }

    public void attemptPropagate(World world, int x, int y, int z) {
    }
}

