/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.dungeon;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import teamport.aether.blocks.dungeon.BlockLogicChestMimic;

public class BlockLogicPaintedChestMimic
extends BlockLogicChestMimic
implements IPainted {
    protected final int unpaintedBlockID;

    public BlockLogicPaintedChestMimic(Block<?> block, Material material, int unpaintedBlockID) {
        super(block, material);
        this.unpaintedBlockID = unpaintedBlockID;
    }

    public void removeDye(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadataWithNotify(x, y, z, this.unpaintedBlockID, meta & 0xFFFFFF0F);
    }

    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((int)((meta & 0xF0) >> 4));
    }

    public int toMetadata(DyeColor dyeColor) {
        return dyeColor.blockMeta << 4;
    }

    public int stripColorFromMetadata(int meta) {
        return meta & 0xFFFFFF0F;
    }

    public void setColor(World world, int x, int y, int z, DyeColor color) {
        super.setColor(world, x, y, z, color);
    }
}

