/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.skyroot;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoorPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockLogicPaintedDoor
extends BlockLogicDoorPainted {
    protected final int unpaintedDoorBlockBottomID;
    protected final int unpaintedDoorBlockTopID;
    private final Supplier<Item> paintedDoorItem;

    public BlockLogicPaintedDoor(Block<?> block, Material material, boolean isTop, int unpaintedDoorBlockTopID, int unpaintedDoorBlockBottomID, Supplier<Item> paintedDoorItem) {
        super(block, material, isTop);
        this.unpaintedDoorBlockTopID = unpaintedDoorBlockTopID;
        this.unpaintedDoorBlockBottomID = unpaintedDoorBlockBottomID;
        this.paintedDoorItem = paintedDoorItem;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this.paintedDoorItem.get(), 1, 15 - (meta >> 4 & 0xF))};
    }

    public void removeDye(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadataWithNotify(x, y, z, this.isTop ? this.unpaintedDoorBlockTopID : this.unpaintedDoorBlockBottomID, meta & 0xF);
        if (this.isTop) {
            world.setBlockAndMetadataWithNotify(x, y - 1, z, this.unpaintedDoorBlockBottomID, meta & 0xF);
        } else {
            world.setBlockAndMetadataWithNotify(x, y + 1, z, this.unpaintedDoorBlockTopID, meta & 0xF);
        }
    }
}

