/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.aerbunny;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class ModelAerbunny
extends ModelBase {
    private final Cube head;
    private final Cube body;
    private final Cube tail;
    private final Cube cloudBody;
    private final Cube e1;
    private final Cube e2;
    private final Cube ff1;
    private final Cube ff2;
    private final Cube g;
    private final Cube g2;
    private final Cube h;
    private final Cube h2;
    private float puffiness;

    public ModelAerbunny() {
        int byte0 = 19;
        this.head = new Cube(0, 0);
        this.head.addBox(-2.0f, -1.0f, -4.0f, 4, 4, 6, 0.0f);
        this.head.setRotationPoint(0.0f, (float)(-1 + byte0), -4.0f);
        this.g = new Cube(14, 0);
        this.g.addBox(-2.0f, -5.0f, -3.0f, 1, 4, 2, 0.0f);
        this.g.setRotationPoint(0.0f, (float)(-1 + byte0), -4.0f);
        this.g2 = new Cube(14, 0);
        this.g2.addBox(1.0f, -5.0f, -3.0f, 1, 4, 2, 0.0f);
        this.g2.setRotationPoint(0.0f, (float)(-1 + byte0), -4.0f);
        this.h = new Cube(20, 0);
        this.h.addBox(-4.0f, 0.0f, -3.0f, 2, 3, 2, 0.0f);
        this.h.setRotationPoint(0.0f, (float)(-1 + byte0), -4.0f);
        this.h2 = new Cube(20, 0);
        this.h2.addBox(2.0f, 0.0f, -3.0f, 2, 3, 2, 0.0f);
        this.h2.setRotationPoint(0.0f, (float)(-1 + byte0), -4.0f);
        this.body = new Cube(0, 10);
        this.body.addBox(-3.0f, -4.0f, -3.0f, 6, 8, 6, 0.0f);
        this.body.setRotationPoint(0.0f, (float)byte0, 0.0f);
        this.tail = new Cube(0, 24);
        this.tail.addBox(-2.0f, 4.0f, -2.0f, 4, 3, 4, 0.0f);
        this.tail.setRotationPoint(0.0f, (float)byte0, 0.0f);
        this.cloudBody = new Cube(29, 0);
        this.cloudBody.addBox(-3.5f, -3.5f, -3.5f, 7, 7, 7, 0.0f);
        this.cloudBody.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.e1 = new Cube(24, 16);
        this.e1.addBox(-2.0f, 0.0f, -1.0f, 2, 2, 2);
        this.e1.setRotationPoint(3.0f, (float)(3 + byte0), -3.0f);
        this.e2 = new Cube(24, 16);
        this.e2.addBox(0.0f, 0.0f, -1.0f, 2, 2, 2);
        this.e2.setRotationPoint(-3.0f, (float)(3 + byte0), -3.0f);
        this.ff1 = new Cube(16, 24);
        this.ff1.addBox(-2.0f, 0.0f, -4.0f, 2, 2, 4);
        this.ff1.setRotationPoint(3.0f, (float)(3 + byte0), 4.0f);
        this.ff2 = new Cube(16, 24);
        this.ff2.addBox(0.0f, 0.0f, -4.0f, 2, 2, 4);
        this.ff2.setRotationPoint(-3.0f, (float)(3 + byte0), 4.0f);
    }

    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.head.render(scale);
        this.g.render(scale);
        this.g2.render(scale);
        this.h.render(scale);
        this.h2.render(scale);
        this.body.render(scale);
        this.tail.render(scale);
        GL11.glPushMatrix();
        float a = 1.0f + this.puffiness * 0.5f;
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)a, (float)a, (float)a);
        this.cloudBody.render(scale);
        GL11.glPopMatrix();
        this.e1.render(scale);
        this.e2.render(scale);
        this.ff1.render(scale);
        this.ff2.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.head.xRot = headPitch / 57.29578f;
        this.head.yRot = headYaw / 57.29578f;
        this.g.xRot = this.head.xRot;
        this.g.yRot = this.head.yRot;
        this.g2.xRot = this.head.xRot;
        this.g2.yRot = this.head.yRot;
        this.h.xRot = this.head.xRot;
        this.h.yRot = this.head.yRot;
        this.h2.xRot = this.head.xRot;
        this.h2.yRot = this.head.yRot;
        this.body.xRot = 1.570796f;
        this.tail.xRot = 1.570796f;
        this.cloudBody.xRot = 1.570796f;
        this.e1.xRot = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.0f * limbYaw;
        this.ff1.xRot = MathHelper.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 1.2f * limbYaw;
        this.e2.xRot = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.0f * limbYaw;
        this.ff2.xRot = MathHelper.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 1.2f * limbYaw;
    }

    public void setPuffiness(float puffiness) {
        this.puffiness = puffiness;
    }
}

