/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.phyg;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.entity.animal.phyg.MobPhyg;
import teamport.aether.entity.animal.phyg.ModelPhyg;

@Environment(value=EnvType.CLIENT)
public class MobRendererPhyg
extends MobRenderer<MobPhyg> {
    public MobRendererPhyg(ModelBase modelbase, float shadowSize) {
        super(modelbase, shadowSize);
        this.setArmorModel(modelbase);
    }

    private boolean renderSaddledPig(MobPhyg entity, int i) {
        this.bindTexture("/assets/aether/textures/entity/phyg/saddle.png");
        return i == 0 && entity != null && entity.getSaddled();
    }

    public float limbSway(MobPhyg pig, float partialTick) {
        if (!(this.mainModel instanceof ModelPhyg)) {
            return super.limbSway((Mob)pig, partialTick);
        }
        ModelPhyg model = (ModelPhyg)this.mainModel;
        float wingFold = MathHelper.lerp((float)pig.getWingFoldO(), (float)pig.getWingFold(), (float)partialTick);
        float wingAngle = MathHelper.lerp((float)pig.getWingAngleO(), (float)pig.getWingAngle(), (float)partialTick);
        float wingBend = -((float)Math.acos(wingFold));
        float x = 32.0f * wingFold / 4.0f;
        float y = -32.0f * (float)Math.sqrt(1.0f - wingFold * wingFold) / 4.0f;
        float z = 0.0f;
        float x2 = x * (float)Math.cos(wingAngle) - y * (float)Math.sin(wingAngle);
        float y2 = x * (float)Math.sin(wingAngle) + y * (float)Math.cos(wingAngle);
        model.getLeftWingInner().setRotationPoint(4.0f + x2, y2 + 12.0f, z);
        model.getRightWingInner().setRotationPoint(-4.0f - x2, y2 + 12.0f, z);
        x2 = (x *= 3.0f) * (float)Math.cos(wingAngle) - y * (float)Math.sin(wingAngle);
        y2 = x * (float)Math.sin(wingAngle) + y * (float)Math.cos(wingAngle);
        model.getLeftWingOuter().setRotationPoint(4.0f + x2, y2 + 12.0f, z);
        model.getRightWingOuter().setRotationPoint(-4.0f - x2, y2 + 12.0f, z);
        model.getLeftWingInner().zRot = wingAngle + wingBend + 1.5707964f;
        model.getLeftWingOuter().zRot = wingAngle - wingBend + 1.5707964f;
        model.getRightWingInner().zRot = -(wingAngle + wingBend - 1.5707964f);
        model.getRightWingOuter().zRot = -(wingAngle - wingBend + 1.5707964f);
        return wingBend;
    }

    public boolean prepareArmor(MobPhyg entity, int renderPass, float partialTick) {
        return this.renderSaddledPig(entity, renderPass);
    }
}

