/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.swet;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import org.jspecify.annotations.NonNull;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherItems;
import teamport.aether.items.accessory.AetherInvisibility;

public class MobSwet
extends MobMonsterAether
implements Enemy,
AetherDeathMessage {
    private boolean friendly;
    private double ydO;
    protected int jumpDelay;
    protected int grabDelay;

    public MobSwet(World world) {
        super(world);
        this.heightOffset = 0.0f;
        this.scoreValue = 200;
        this.setSize(1.4f, 1.2f);
        this.setPos(this.x, this.y, this.z);
        this.jumpDelay = 20;
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"swet");
        this.moveSpeed = 1.5f;
        this.mobDrops.add(new WeightedRandomLootObject(AetherBlocks.AERCLOUD_BLUE.getDefaultStack(), 0));
    }

    public List<WeightedRandomLootObject> getMobDrops() {
        ArrayList<WeightedRandomLootObject> drops = new ArrayList<WeightedRandomLootObject>();
        drops.add(new WeightedRandomLootObject(AetherBlocks.AERCLOUD_BLUE.getDefaultStack(), 1, 2));
        return drops;
    }

    public void causeFallDamage(float distance) {
        super.causeFallDamage(distance / 2.0f);
    }

    public int getMaxHealth() {
        return 16;
    }

    public void jump() {
        this.yd = this.passenger != null ? 1.6 : 0.6;
    }

    public double getRideHeight() {
        return 0.1;
    }

    public void doTickEffect() {
        if (this.world != null && this.random.nextInt(2) == 0) {
            ParticleMaker.spawnParticle(this.world, "splash", this.x, this.y, this.z, this.world.rand.nextDouble(), this.world.rand.nextDouble(), this.world.rand.nextDouble(), 0);
        }
    }

    public Item getBounceParticle() {
        return AetherItems.FOOD_GUMMY_BLUE;
    }

    public void tick() {
        if (this.world == null) {
            return;
        }
        this.doTickEffect();
        if (this.passenger != null && (!this.passenger.isAlive() || this.passenger.removed)) {
            this.ejectRider();
        }
        if (this.getHealth() <= 0) {
            this.ejectRider();
        }
        if (this.grabDelay > 0) {
            --this.grabDelay;
        }
        this.ydO = this.yd;
        boolean flag = this.onGround;
        super.tick();
        if (this.onGround && !flag) {
            int i = 2;
            for (int j = 0; j < i * 8; ++j) {
                float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
                double f1 = this.random.nextDouble() * 0.5 + 0.5;
                double f2 = (double)(MathHelper.sin((float)f) * (float)i) * 0.5 * f1;
                double f3 = (double)(MathHelper.cos((float)f) * (float)i) * 0.5 * f1;
                ParticleMaker.spawnParticle(this.world, "item", this.x + f2, this.bb.minY, this.z + f3, 0.0, 0.0, 0.0, this.getBounceParticle().id);
            }
            this.world.playSoundAtEntity(null, (Entity)this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
        }
        if (!this.world.isClientSide && !this.world.getDifficulty().canHostileMobsSpawn()) {
            this.remove();
        }
    }

    public void knockBack(Entity entity, int i, double d, double d1) {
        if (this.passenger == null || entity != this.passenger) {
            super.knockBack(entity, i, d, d1);
        }
    }

    public void updateAI() {
        boolean targetPlayer;
        AetherInvisibility invPlayer;
        this.tryToDespawn();
        if (this.world == null) {
            return;
        }
        Player entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
        if (entityplayer instanceof AetherInvisibility && (invPlayer = (AetherInvisibility)entityplayer).aether$isInvisible()) {
            entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 2.0);
        }
        boolean bl = targetPlayer = entityplayer != null && entityplayer.getGamemode().areMobsHostile() && this.canEntityBeSeen((Entity)entityplayer);
        if (!this.friendly && entityplayer != null && targetPlayer && entityplayer != this.passenger) {
            this.lookAt((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.onGround && this.jumpDelay-- <= 0) {
            if (!targetPlayer) {
                float rotation = (this.world.rand.nextFloat() - 0.5f) * 90.0f;
                this.yRot += rotation;
                this.jumpDelay = this.random.nextInt(80) + 40;
            } else {
                this.jumpDelay = this.random.nextInt(20) + 10;
                this.jumpDelay /= 3;
            }
            this.isJumping = true;
            this.world.playSoundAtEntity(null, (Entity)this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            this.world.playSoundAtEntity(null, (Entity)this, "mob.slimeattack", 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.moveStrafing = 1.0f - this.random.nextFloat() * 2.0f;
            this.moveForward = 8.0f;
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    public void attackEntity(@NonNull Entity entity, float distance) {
        if (this.isAlive() && !this.friendly && this.attackTime <= 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY && this.getHealth() > 0 && !this.dead) {
            this.attackTime = 200;
            if (this.world != null) {
                this.world.playSoundAtEntity(null, (Entity)this, "mob.slimeattack", 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            entity.hurt((Entity)this, 2, DamageType.COMBAT);
        }
    }

    public void playerTouch(Player player) {
        if (this.isAlive() && !this.friendly && this.canEntityBeSeen((Entity)player) && (double)this.distanceTo((Entity)player) < 2.0 && player.hurt((Entity)this, 2, DamageType.COMBAT) && this.getHealth() > 0 && !this.dead && player.isAlive() && this.grabDelay == 0) {
            player.startRiding((IVehicle)this);
            this.grabDelay = 100;
        }
    }

    public String getHurtSound() {
        return "mob.slime";
    }

    public String getDeathSound() {
        return "mob.slime";
    }

    public float getSoundVolume() {
        return 0.3f;
    }

    @Override
    public boolean canSpawnHere() {
        if (this.world == null) {
            return false;
        }
        int x = MathHelper.floor((double)this.x);
        int y = MathHelper.floor((double)this.bb.minY);
        int z = MathHelper.floor((double)this.z);
        int id = this.world.getBlockId(x, y - 1, z);
        if (this.world.getSavedLightValue(LightLayer.Block, x, y, z) > 7) {
            return false;
        }
        Block block = Blocks.blocksList[id];
        if (block == null) {
            return false;
        }
        if (this.world.rand.nextInt(5) == 0) {
            return block.hasTag(AetherBlockTags.PASSIVE_MOBS_SPAWN);
        }
        return false;
    }

    public boolean isFriendly() {
        return this.friendly;
    }

    public void setFriendly(boolean friendly) {
        this.friendly = friendly;
    }

    public double getYdO() {
        return this.ydO;
    }
}

