/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.vehicle.parachute;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.AetherRideable;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.mixin.accessors.EntityAccessor;
import teamport.aether.net.message.AetherRideableNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class EntityParachute
extends Mob
implements AetherRideable {
    protected float maxSpeed = 0.1f;
    protected String pathParticle = "explode";
    protected Block<?> particleBlock = AetherBlocks.AERCLOUD_WHITE;
    protected double xdChange = 0.0;
    protected double zdChange = 0.0;

    public EntityParachute(@Nullable World world) {
        super(world);
        this.setSize(1.0f, 1.0f);
    }

    public boolean makeStepSound() {
        return false;
    }

    public void tick() {
        super.tick();
        double x = this.x + ((EntityAccessor)((Object)this)).getRandom().nextDouble() * 0.75 * 2.0 - 0.75;
        double y = this.bb.minY - 0.5 + ((EntityAccessor)((Object)this)).getRandom().nextDouble() * 0.75 * 2.0 - 0.75;
        double z = this.z + ((EntityAccessor)((Object)this)).getRandom().nextDouble() * 0.75 * 2.0 - 0.75;
        ParticleMaker.spawnParticle(this.world, this.pathParticle, x, y, z, 0.0, 0.0, 0.0, 0);
        if (this.passenger == null) {
            this.breakParachute();
            this.remove();
        } else {
            this.passenger.handleSpecialVehicleControl();
        }
        this.handleParachuteMovement();
        if (this.onGround || this.isInWater()) {
            Entity rider = this.ejectRider();
            if (rider != null) {
                rider.fling(0.0, (double)0.3f, 0.0, 0.0f);
            }
            this.breakParachute();
            this.remove();
        }
    }

    public void breakParachute() {
        for (int i = 0; i < 16 + this.random.nextInt(10); ++i) {
            float posZ;
            float posY;
            float posX;
            float faceX = this.bbWidth * this.random.nextFloat();
            float faceY = this.bbWidth * this.random.nextFloat();
            Direction dir = Direction.directions[this.random.nextInt(Direction.directions.length)];
            switch (dir) {
                case WEST: {
                    posX = (float)this.x;
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z + (double)faceX);
                    break;
                }
                case EAST: {
                    posX = (float)(this.x + 1.0);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z + (double)faceX);
                    break;
                }
                case SOUTH: {
                    posX = (float)(this.x + (double)faceX);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)(this.z + 1.0);
                    break;
                }
                case NORTH: {
                    posX = (float)(this.x + (double)faceX);
                    posY = (float)(this.y + (double)faceY);
                    posZ = (float)this.z;
                    break;
                }
                case DOWN: {
                    posX = (float)(this.x + (double)faceX);
                    posY = (float)(this.y - 1.0);
                    posZ = (float)(this.z + (double)faceY);
                    break;
                }
                default: {
                    posX = (float)(this.x + (double)faceX);
                    posY = (float)(this.y + 1.0);
                    posZ = (float)(this.z + (double)faceY);
                }
            }
            ParticleMaker.spawnParticle(this.world, "block", posX - 0.5f, posY + 0.25f, posZ - 0.5f, 0.0, 0.005, 0.0, this.particleBlock.id());
        }
        if (this.world != null) {
            this.world.playBlockSoundEffect(null, this.x, this.y, this.z, this.particleBlock, EnumBlockSoundEffectType.MINE);
        }
    }

    protected void handleParachuteMovement() {
        this.move(this.xd, this.yd, this.zd);
        if (this.yd < -0.2) {
            this.yd *= 0.5;
        }
        this.xd *= (double)0.9f;
        this.zd *= (double)0.9f;
    }

    public void vehicleMovement() {
        this.moveSpeed = 0.0f;
        this.moveStrafing = 0.0f;
        if (this.passenger != null) {
            this.passenger.fallDistance = 0.0f;
        }
        this.xd += this.xdChange;
        this.zd += this.zdChange;
        this.xdChange = 0.0;
        this.zdChange = 0.0;
        double speed = Math.sqrt(this.xd * this.xd + this.zd * this.zd);
        if (speed > (double)this.maxSpeed) {
            double factor = (double)this.maxSpeed / speed;
            this.xd *= factor;
            this.zd *= factor;
        }
    }

    public void updateAI() {
        if (this.passenger != null) {
            this.vehicleMovement();
        }
    }

    public double getRideHeight() {
        return this.bbHeight + 0.2f;
    }

    public void causeFallDamage(float distance) {
    }

    public boolean hurt(Entity attacker, int damage, DamageType type) {
        return false;
    }

    @Override
    public void controlEntity(float moveForward, float moveStrafe, boolean isJumping, float xRot, float yRot) {
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new AetherRideableNetworkMessage(moveForward, moveStrafe, isJumping, xRot, yRot));
        }
        float yawDeg = (float)((double)yRot * (Math.PI / 180));
        float step = 0.175f;
        if (moveForward > 0.1f || moveForward < -0.1f) {
            this.xdChange += (double)moveForward * -Math.sin(yawDeg) * (double)step;
            this.zdChange += (double)moveForward * Math.cos(yawDeg) * (double)step;
        }
        if (moveStrafe > 0.1f || moveStrafe < -0.1f) {
            this.xdChange += (double)moveStrafe * Math.cos(yawDeg) * (double)step;
            this.zdChange += (double)moveStrafe * Math.sin(yawDeg) * (double)step;
        }
        this.yRotO = this.yRot = yRot;
    }

    public String getPathParticle() {
        return this.pathParticle;
    }
}

