/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.lang.I18n;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.boss.AetherBossList;
import teamport.aether.entity.boss.EnemyBoss;

public class ComponentBossBar
extends HudComponentMovable {
    private static final int BAR_WIDTH = 256;
    private static final int BAR_HEIGHT = 16;
    private static final int TEXT_OFFSET = -10;
    private static final int SPACING = 13;
    private static final int BAR_AMOUNT_LIMIT = 3;
    private static int height;

    public ComponentBossBar(String key, Layout layout) {
        super(key, 256, 16, layout);
    }

    public boolean isVisible(Minecraft minecraft) {
        return !this.getBossesFromPlayer(minecraft).isEmpty() && minecraft.gameSettings.immersiveMode.drawHotbar();
    }

    public int getAnchorY(ComponentAnchor anchor) {
        return (int)(anchor.yPosition * (float)height);
    }

    public int getYSize(Minecraft mc) {
        return height;
    }

    public List<Mob> getBossesFromPlayer(Minecraft mc) {
        List<Mob> bossList = ((AetherBossList)mc.thePlayer).aether$getBossList();
        return bossList.subList(0, Math.min(bossList.size(), 3));
    }

    public void render(Minecraft mc, HudIngame hudIngame, int xSizeScreen, int ySizeScreen, float f) {
        int i = 0;
        List<Mob> mobList = this.getBossesFromPlayer(mc);
        height = mobList.isEmpty() ? 0 : 29 * mobList.size() + 13;
        for (Mob mob : mobList) {
            this.drawBossBar(mc, (Gui)hudIngame, mob, i++, xSizeScreen, ySizeScreen);
        }
    }

    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        height = 100;
        for (int offset = 0; offset < 3; ++offset) {
            int barX = this.getLayout().getComponentX(mc, (HudComponent)this, xSizeScreen);
            int barY = this.getLayout().getComponentY(mc, (HudComponent)this, ySizeScreen) + 29 * offset + 13;
            int textX = barX + 128;
            int textY = barY + -10;
            this.drawProgressBar(mc, gui, barX, barY, 100, 100);
            String title = I18n.getInstance().translateKey("aether.menu.boss_bar.preview_name");
            gui.drawStringCentered(mc.font, title, textX, textY, -1);
        }
    }

    void drawBossBar(Minecraft mc, Gui gui, Mob mob, int offset, int xSizeScreen, int ySizeScreen) {
        int barX = this.getLayout().getComponentX(mc, (HudComponent)this, xSizeScreen);
        int barY = this.getLayout().getComponentY(mc, (HudComponent)this, ySizeScreen) + 29 * offset + 13;
        int textX = barX + 128;
        int textY = barY + -10;
        this.drawProgressBar(mc, gui, barX, barY, mob.getHealth(), mob.getMaxHealth());
        String entityName = mob instanceof EnemyBoss ? ((EnemyBoss)mob).getBossTitle() : mob.getDisplayName();
        gui.drawStringCentered(mc.font, entityName, textX, textY, -1);
    }

    public void drawProgressBar(Minecraft mc, Gui gui, int barX, int barY, int health, int maxHealth) {
        float progress = (float)health / (float)maxHealth;
        int progressWidth = (int)(256.0f * progress);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.textureManager.bindTexture(mc.textureManager.loadTexture("/assets/aether/textures/gui/boss_healthbar.png"));
        gui.drawTexturedModalRect(barX, barY, 0, 16, 256, 16);
        gui.drawTexturedModalRect(barX, barY, 0, 0, progressWidth, 16);
    }
}

