/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.save.SaveFile;
import org.lwjgl.input.Keyboard;

public class UNDataMissingScreen
extends Screen {
    private final Screen previous;
    private final SaveFile level;
    private String[] body;
    private int y;
    private int currBtn = 0;
    private ButtonElement continueBtn;
    private final I18n i18n = I18n.getInstance();

    public UNDataMissingScreen(Screen previous, SaveFile level) {
        this.previous = previous;
        this.level = level;
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.body = this.i18n.translateKeyAndFormat("aether.gui.un_missing_warn.body", new Object[]{this.level.getDisplayName(), this.level.getFileName()}).split("\n");
        int bodyHeight = this.body.length * this.font.fontHeight;
        this.y = (int)((double)this.height * 0.25);
        this.buttons.clear();
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.y + bodyHeight + 24, this.i18n.translateKey("gui.select_world.button.cancel")));
        this.continueBtn = new ButtonElement(2, this.width / 2 - 100, this.y + bodyHeight + 48, this.i18n.translateKey("aether.gui.un_missing_warn.proceed_0"));
        this.buttons.add(this.continueBtn);
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        for (int i = 0; i < this.body.length; ++i) {
            this.drawStringCentered(this.font, this.body[i], this.width / 2, this.y + this.font.fontHeight * i, DyeColor.WHITE.color.value);
        }
        super.render(mx, my, partialTick);
    }

    protected void buttonClicked(ButtonElement button) {
        if (button.enabled) {
            if (button.id == 1) {
                this.mc.displayScreen(this.previous);
            }
            if (button.id == 2) {
                if (this.currBtn >= 3) {
                    this.mc.playerController = new PlayerControllerSP(this.mc);
                    this.mc.startWorld(this.level.getFileName(), this.level.getDisplayName(), 0L);
                    this.mc.displayScreen(null);
                    return;
                }
                this.continueBtn.displayString = this.i18n.translateKey("aether.gui.un_missing_warn.proceed_" + ++this.currBtn);
                if (this.currBtn == 1) {
                    this.continueBtn.xPosition = (int)((float)(this.width - 200) * 0.25f) / 20 * 20;
                    this.continueBtn.yPosition = (int)((float)(this.height - 20) * 0.75f) / 20 * 20;
                } else if (this.currBtn == 2) {
                    this.continueBtn.xPosition = (int)((float)(this.width - 200) * 0.75f) / 20 * 20;
                    this.continueBtn.yPosition = (int)((float)(this.height - 20) * 0.05f) / 20 * 20;
                } else if (this.currBtn == 3) {
                    this.continueBtn.xPosition = this.width / 2 - 100;
                    this.continueBtn.yPosition = this.y + this.body.length * this.font.fontHeight + 48;
                }
            }
        }
    }
}

