/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.tile.TileEntitySignSkyroot;
import teamport.aether.gui.AetherScreens;

public class ItemSignSkyroot
extends Item {
    private final boolean isPainted;

    public ItemSignSkyroot(String name, String namespaceId, int id, boolean isPainted) {
        super(name, namespaceId, id);
        this.isPainted = isPainted;
    }

    private Block<? extends BlockLogic> getBlockWall() {
        if (this.isPainted) {
            return AetherBlocks.SIGN_WALL_PLANKS_SKYROOT_PAINTED;
        }
        return AetherBlocks.SIGN_WALL_PLANKS_SKYROOT;
    }

    private Block<? extends BlockLogic> getBlockPost() {
        if (this.isPainted) {
            return AetherBlocks.SIGN_POST_PLANKS_SKYROOT_PAINTED;
        }
        return AetherBlocks.SIGN_POST_PLANKS_SKYROOT;
    }

    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int meta;
        int sideHit = side.getId();
        if (side == Side.BOTTOM) {
            return false;
        }
        if (!world.getBlockMaterial(blockX, blockY, blockZ).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (blockY < 0 || blockY >= world.getHeightBlocks()) {
            return false;
        }
        if (!AetherBlocks.SIGN_POST_PLANKS_SKYROOT.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        Block<? extends BlockLogic> blockToPlace = sideHit == 1 ? this.getBlockPost() : this.getBlockWall();
        int n = meta = sideHit == 1 ? MathHelper.floor((double)((double)((entityplayer.yRot + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF : sideHit;
        if (this.isPainted) {
            meta = DyeColor.colorFromItemMeta((int)itemstack.getMetadata()).blockMeta << 4 | meta;
        }
        world.playBlockSoundEffect((Entity)entityplayer, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), blockToPlace, EnumBlockSoundEffectType.PLACE);
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, blockToPlace.id(), meta);
        itemstack.consumeItem(entityplayer);
        TileEntitySignSkyroot tileEntity = (TileEntitySignSkyroot)world.getTileEntity(blockX, blockY, blockZ);
        if (tileEntity != null) {
            tileEntity.setOwner(entityplayer);
            ((AetherScreens)entityplayer).aether$displaySignSkyrootEditorScreen(tileEntity);
        }
        return true;
    }

    public String getLanguageKey(ItemStack itemstack) {
        if (!this.isPainted) {
            return super.getLanguageKey(itemstack);
        }
        return super.getKey() + "." + DyeColor.colorFromItemMeta((int)itemstack.getMetadata()).colorID;
    }
}

