/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory.gloves;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.util.helper.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import teamport.aether.items.AetherArmorMaterial;
import teamport.aether.items.accessory.ItemGloves;

@Mixin(value={ContainerInventory.class}, remap=false)
public abstract class ContainerInventoryMixinGlovesDamage {
    @ModifyExpressionValue(method={"getDamageVsEntity(Lnet/minecraft/core/entity/Entity;)I"}, at={@At(value="CONSTANT", args={"intValue=1"})})
    private int getGloveDamage(int original) {
        ContainerInventory inv = (ContainerInventory)this;
        ItemStack stack = inv.armorInventory[4];
        if (stack == null || !(stack.getItem() instanceof ItemGloves)) {
            return original;
        }
        ItemGloves gloves = (ItemGloves)stack.getItem();
        ArmorMaterial material = gloves.getArmorMaterial();
        if (material != null && material == AetherArmorMaterial.ZANITE) {
            float durabilityProgress = (float)stack.getMetadata() / (float)material.durability;
            float endingDamage = (float)gloves.getDamage() * 2.0f;
            return Math.round(MathHelper.lerp((float)gloves.getDamage(), (float)endingDamage, (float)durabilityProgress));
        }
        return Math.max(gloves.getDamage(), original);
    }
}

