/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.player.phoenix;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.DamageType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import teamport.aether.helper.MixinHelper;

@Mixin(value={Entity.class}, remap=false)
public abstract class PlayerMixinFireImmunityBurn {
    @Shadow
    public double x;
    @Shadow
    public double y;
    @Shadow
    public double z;
    @Shadow
    public float bbHeight;
    @Shadow
    public float bbWidth;

    @Shadow
    public abstract boolean hurt(Entity var1, int var2, DamageType var3);

    @WrapMethod(method={"burn(I)V"})
    private void burn(int damage, Operation<Void> original) {
        if (!((Entity)this instanceof Player)) {
            original.call(new Object[]{damage});
            return;
        }
        Player player = (Player)this;
        if (MixinHelper.fireResistanceCount(player.inventory) >= 3) {
            MixinHelper.damageArmourWithEffect(1, player, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return;
        }
        original.call(new Object[]{damage});
    }

    @WrapMethod(method={"thunderHit(Lnet/minecraft/core/entity/EntityLightning;)V"})
    private void thunderHit(EntityLightning bolt, Operation<Void> original) {
        if (!((Entity)this instanceof Player)) {
            original.call(new Object[]{bolt});
            return;
        }
        Player player = (Player)this;
        if (MixinHelper.fireResistanceCount(player.inventory) >= 5) {
            this.hurt(null, 5, DamageType.FIRE);
            MixinHelper.damageArmourWithEffect(1, player, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return;
        }
        original.call(new Object[]{bolt});
    }
}

