/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.armor.wolf;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import teamport.aether.helper.MixinHelper;
import teamport.aether.helper.ParticleMaker;

@Mixin(value={Entity.class}, remap=false)
public abstract class MobWolfMixinFireImmunityBurn {
    @Shadow
    public @Nullable World world;
    @Shadow
    public double x;
    @Shadow
    public double y;
    @Shadow
    public double z;
    @Shadow
    public float bbHeight;
    @Shadow
    public float bbWidth;

    @WrapMethod(method={"burn(I)V"})
    private void burn(int damage, Operation<Void> original) {
        if (!((Entity)this instanceof MobWolf)) {
            original.call(new Object[]{damage});
            return;
        }
        if (MixinHelper.isImmuneToFire((MobWolf)this)) {
            if (this.world == null) {
                return;
            }
            ParticleMaker.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return;
        }
        original.call(new Object[]{damage});
    }

    @WrapMethod(method={"thunderHit(Lnet/minecraft/core/entity/EntityLightning;)V"})
    private void thunderHit(EntityLightning bolt, Operation<Void> original) {
        if (!((Entity)this instanceof MobWolf)) {
            original.call(new Object[]{bolt});
            return;
        }
        if (MixinHelper.isImmuneToFire((MobWolf)this)) {
            if (this.world == null) {
                return;
            }
            ParticleMaker.spawnSmokeParticles(this.world, this.x, this.y, this.z, this.bbHeight, this.bbWidth);
            return;
        }
        original.call(new Object[]{bolt});
    }
}

