/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.player;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.World;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import teamport.aether.entity.boss.AetherBossList;
import teamport.aether.entity.boss.EnemyBoss;
import teamport.aether.net.message.BossListNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

@Mixin(value={Player.class}, remap=false)
public abstract class PlayerBossListMixin
extends Mob
implements AetherBossList {
    @Unique
    private List<Mob> bossList = new ArrayList<Mob>();

    protected PlayerBossListMixin(@Nullable World world) {
        super(world);
    }

    @Override
    public List<Mob> aether$getBossList() {
        ArrayList<Mob> bosses = new ArrayList<Mob>(this.bossList);
        for (Mob boss : this.bossList) {
            if ((!(boss instanceof EnemyBoss) || ((EnemyBoss)boss).canFight()) && boss.isAlive() && boss.world != null && this.world != null && boss.world.dimension == this.world.dimension && !(boss.distanceTo((Entity)this) > 80.0f)) continue;
            bosses.remove(boss);
        }
        this.bossList = bosses;
        return this.bossList;
    }

    @Override
    public void aether$TryAddBossList(Mob mob) {
        if (!this.bossList.contains(mob)) {
            this.bossList.add(mob);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToPlayer((Player)((Player)this), (NetworkMessage)new BossListNetworkMessage(BossListNetworkMessage.Type.ADD, (Entity)mob));
            }
        }
    }

    @Override
    public void aether$clearBossList() {
        this.bossList.clear();
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayer((Player)((Player)this), (NetworkMessage)BossListNetworkMessage.clear());
        }
    }

    @Override
    public void aether$removeFromBossList(Mob mob) {
        this.bossList.remove(mob);
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayer((Player)((Player)this), (NetworkMessage)new BossListNetworkMessage(BossListNetworkMessage.Type.REMOVE, (Entity)mob));
        }
    }

    @Inject(method={"attackTargetEntityWithCurrentItem(Lnet/minecraft/core/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void attackTargetEntityWithCurrentItem(Entity entity, CallbackInfo ci) {
        if (entity instanceof EnemyBoss && entity instanceof Mob && !this.bossList.contains(entity)) {
            this.aether$TryAddBossList((Mob)entity);
        }
    }

    @Inject(method={"onDeath(Lnet/minecraft/core/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void onDeath(CallbackInfo ci) {
        this.bossList.clear();
    }
}

