/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models;

import java.awt.image.BufferedImage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Color;
import teamport.aether.world.AetherDimension;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.DungeonLogic;
import teamport.aether.world.feature.util.map.DungeonMap;

@Environment(value=EnvType.CLIENT)
public class DynamicTextureDungeonCompass
extends DynamicTexture {
    private final Minecraft minecraft;
    private byte[] compassImageData;
    private double angleFinal;
    private double delta;
    private double scaleFactor;
    public final Color needleColor = new Color().setRGB(255, 222, 60);
    private static final int POSITION_UPDATE_COOLDOWN = 1000;
    private long lastPositionUpdateStamp = 0L;
    private static WorldFeaturePoint positionCache = null;

    public DynamicTextureDungeonCompass(Minecraft minecraft, IconCoordinate iconCoordinate) {
        super(iconCoordinate);
        this.minecraft = minecraft;
    }

    public void postInit() {
        this.initTexture();
        BufferedImage atlas = this.targetTexture.parentAtlas.atlas;
        this.compassImageData = new byte[this.targetTexture.getArea() * 4];
        for (int x = 0; x < this.targetTexture.width; ++x) {
            for (int y = 0; y < this.targetTexture.height; ++y) {
                DynamicTextureDungeonCompass.putPixel((byte[])this.compassImageData, (int)(y * this.targetTexture.width + x), (int)atlas.getRGB(this.targetTexture.iconX + x, this.targetTexture.iconY + y));
            }
        }
        this.scaleFactor = (double)this.targetTexture.width / 16.0;
    }

    public boolean runUpdates(boolean isPaused) {
        return !isPaused;
    }

    public double getAngle() {
        if (this.minecraft.currentWorld == null || this.minecraft.thePlayer == null) {
            return 0.0;
        }
        if (this.minecraft.currentWorld.dimension.id == AetherDimension.getAether().id) {
            WorldFeaturePoint coord = null;
            PlayerLocal player = this.minecraft.thePlayer;
            long time = System.currentTimeMillis();
            if (time - this.lastPositionUpdateStamp > 1000L) {
                WorldFeaturePoint playerPos = WorldFeaturePoint.wfpoint((Entity)player);
                for (DungeonLogic entry : DungeonMap.getDungeonList()) {
                    WorldFeaturePoint point;
                    if (entry == null || (point = entry.getPosition()) == null || coord != null && !(point.distanceTo(playerPos) < coord.distanceTo(playerPos))) continue;
                    coord = point;
                }
                positionCache = coord;
                this.lastPositionUpdateStamp = time;
            } else {
                coord = positionCache;
            }
            if (coord != null && player.distanceTo((double)coord.getX(), player.y, (double)coord.getZ()) > 16.0) {
                double distX = (double)coord.getX() - player.x;
                double distZ = (double)coord.getZ() - player.z;
                return (double)(player.yRot - 90.0f) * Math.PI / 180.0 - Math.atan2(distZ, distX);
            }
        }
        return Math.random() * Math.PI * 2.0;
    }

    public void update() {
        int a;
        int b;
        int g;
        int r;
        int j;
        int y2;
        int x2;
        int i;
        double angleSmooth;
        for (int _x = 0; _x < this.targetTexture.width; ++_x) {
            for (int _y = 0; _y < this.targetTexture.height; ++_y) {
                int i2 = _y * this.targetTexture.width + _x;
                int a2 = this.compassImageData[i2 * 4 + 3] & 0xFF;
                int r2 = this.compassImageData[i2 * 4] & 0xFF;
                int g2 = this.compassImageData[i2 * 4 + 1] & 0xFF;
                int b2 = this.compassImageData[i2 * 4 + 2] & 0xFF;
                this.imageData[i2 * 4] = (byte)r2;
                this.imageData[i2 * 4 + 1] = (byte)g2;
                this.imageData[i2 * 4 + 2] = (byte)b2;
                this.imageData[i2 * 4 + 3] = (byte)a2;
            }
        }
        double angle = this.getAngle();
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
        double x = Math.sin(this.angleFinal);
        double y = Math.cos(this.angleFinal);
        double xs = (double)this.targetTexture.width / 2.0 + 0.5;
        double ys = (double)this.targetTexture.height / 2.0 - 0.5;
        for (i = (int)(-4.0 * this.scaleFactor); i <= (int)(4.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + y * (double)i * 0.3);
            y2 = (int)(ys - x * (double)i * 0.3 * 0.5);
            j = y2 * this.targetTexture.width + x2;
            r = 100;
            g = 100;
            b = 100;
            a = 255;
            this.imageData[j * 4] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
        for (i = (int)(-8.0 * this.scaleFactor); i <= (int)(16.0 * this.scaleFactor); ++i) {
            r = i >= 0 ? this.needleColor.getRed() : 100;
            g = i >= 0 ? this.needleColor.getGreen() : 100;
            b = i >= 0 ? this.needleColor.getBlue() : 100;
            a = 255;
            x2 = (int)(xs + x * (double)i * 0.3);
            y2 = (int)(ys + y * (double)i * 0.3 * 0.5);
            j = y2 * this.targetTexture.width + x2;
            this.imageData[j * 4] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
    }
}

