/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models.dungeon;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelRotatable;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;
import teamport.aether.world.feature.util.WorldFeaturePoint;

@Environment(value=EnvType.CLIENT)
public class BlockModelDungeonDoor<T extends BlockLogic>
extends BlockModelRotatable<T> {
    private final int width;
    private final int height;
    private final IconCoordinate buffer = new IconCoordinate(TextureRegistry.blockAtlas, null, null);
    private IconCoordinate particleTexture = TextureRegistry.getTexture((String)"minecraft:block/texture_missing");
    private IconCoordinate particleTextureRetro = TextureRegistry.getTexture((String)"minecraft:block/texture_missing");

    public BlockModelDungeonDoor(Block<T> block, int width, int height) {
        super(block);
        this.width = width;
        this.height = height;
    }

    protected IconCoordinate ctm(BlockModelStandard.TextureLayer layer, IconCoordinate fallback, WorldSource blockAccess, int x, int y, int z, Side side) {
        int u;
        int v;
        boolean left;
        int meta = blockAccess.getBlockMetadata(x, y, z);
        Side sideRotated = Side.getSideById((int)Sides.orientationLookUpHorizontal[6 * Math.min(meta & 7, 5) + side.getId()]);
        IconCoordinate baseTex = layer.get(sideRotated);
        if (baseTex == null) {
            return fallback;
        }
        Direction dir = BlockLogicRotatable.getDirectionFromMeta((int)meta);
        Direction offsetLeft = dir.rotate(-1);
        Direction offsetRight = dir.rotate(1);
        if (dir == Direction.WEST || dir == Direction.SOUTH) {
            offsetLeft = offsetLeft.getOpposite();
            offsetRight = offsetRight.getOpposite();
        }
        boolean up = blockAccess.getBlockId(x, y + 1, z) == this.block.id();
        boolean down = blockAccess.getBlockId(x, y - 1, z) == this.block.id();
        boolean right = blockAccess.getBlockId(x + offsetRight.getOffsetX(), y + offsetRight.getOffsetY(), z + offsetRight.getOffsetZ()) == this.block.id();
        boolean bl = left = blockAccess.getBlockId(x + offsetLeft.getOffsetX(), y + offsetLeft.getOffsetY(), z + offsetLeft.getOffsetZ()) == this.block.id();
        if (!up) {
            v = 0;
        } else if (!down) {
            v = this.height - 1;
        } else {
            for (v = 0; v < this.height - 1 && blockAccess.getBlockId(x, y + 1 + v, z) == this.block.id(); ++v) {
            }
        }
        if (!left) {
            u = 0;
        } else if (!right) {
            u = this.width - 1;
        } else {
            WorldFeaturePoint p = new WorldFeaturePoint(x, y, z);
            for (u = 0; u < this.width - 1 && blockAccess.getBlockId((p = p.moveInDirection(offsetRight).copy()).getX(), p.getY(), p.getZ()) == this.block.id(); ++u) {
            }
            u = this.width - 1 - u;
        }
        if (side == Side.EAST || side == Side.NORTH) {
            u = this.width - 1 - u;
        }
        int textWidth = baseTex.width / this.width;
        int textHeight = baseTex.height / this.height;
        this.buffer.setPosition(baseTex.iconX + u * textWidth, baseTex.iconY + v * textHeight);
        this.buffer.setDimension(textWidth, textHeight);
        return this.buffer;
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        if (this.isRetro()) {
            return this.ctm(this.retroBlockTextures, TextureRegistry.getTexture((String)"minecraft:block/texture_missing"), blockAccess, x, y, z, side);
        }
        return this.ctm(this.blockTextures, TextureRegistry.getTexture((String)"minecraft:block/texture_missing"), blockAccess, x, y, z, side);
    }

    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        if (this.isRetro()) {
            return this.ctm(this.retroOverbrightTextures, null, blockAccess, x, y, z, Side.getSideById((int)side));
        }
        return this.ctm(this.overbrightTextures, null, blockAccess, x, y, z, Side.getSideById((int)side));
    }

    public IconCoordinate getParticleTexture(Side side, int meta) {
        if (this.isRetro()) {
            return this.particleTextureRetro;
        }
        return this.particleTexture;
    }

    public BlockModelDungeonDoor<T> setParticleTexture(boolean isRetro, String texture) {
        if (isRetro) {
            this.particleTextureRetro = TextureRegistry.getTexture((String)texture);
        } else {
            this.particleTexture = TextureRegistry.getTexture((String)texture);
        }
        return this;
    }
}

