/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.models.skyroot;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.block.model.BlockModelTrapDoor;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicTrapDoor;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

@Environment(value=EnvType.CLIENT)
public class BlockModelPaintedSkyrootTrapDoor<T extends BlockLogic>
extends BlockModelTrapDoor<T> {
    private static final IconCoordinate[] TOP_TEXTURES = new IconCoordinate[16];
    private static final IconCoordinate[] SIDE_TEXTURES = new IconCoordinate[16];

    public BlockModelPaintedSkyrootTrapDoor(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4 & 0xF;
        int orientation = data & 3;
        if (BlockLogicTrapDoor.isTrapdoorOpen((int)data)) {
            int index = Sides.orientationLookUpTrapdoorOpen[6 * orientation + side.getId()];
            return index < 2 ? TOP_TEXTURES[color] : SIDE_TEXTURES[color];
        }
        return side.getAxis() == Axis.Y ? TOP_TEXTURES[color] : SIDE_TEXTURES[color];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelPaintedSkyrootTrapDoor.TOP_TEXTURES[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/trapdoor/skyroot/" + c.colorID + "/top"));
            BlockModelPaintedSkyrootTrapDoor.SIDE_TEXTURES[c.blockMeta] = TextureRegistry.getTexture((String)("aether:block/trapdoor/skyroot/" + c.colorID + "/side"));
        }
    }
}

