/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net.message;

import net.minecraft.core.entity.player.Player;
import org.jspecify.annotations.NonNull;
import teamport.aether.entity.AetherRideable;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class AetherRideableNetworkMessage
implements NetworkMessage {
    private float moveForward;
    private float moveStrafe;
    private float xRot;
    private float yRot;
    private boolean isJumping;

    public AetherRideableNetworkMessage() {
    }

    public AetherRideableNetworkMessage(float moveForward, float moveStrafe, boolean isJumping, float xRot, float yRot) {
        this.moveForward = moveForward;
        this.moveStrafe = moveStrafe;
        this.isJumping = isJumping;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public void encodeToUniversalPacket(@NonNull UniversalPacket packet) {
        packet.writeDouble((double)this.moveForward);
        packet.writeDouble((double)this.moveStrafe);
        packet.writeBoolean(this.isJumping);
        packet.writeDouble((double)this.xRot);
        packet.writeDouble((double)this.yRot);
    }

    public void decodeFromUniversalPacket(@NonNull UniversalPacket packet) {
        this.moveForward = (float)packet.readDouble();
        this.moveStrafe = (float)packet.readDouble();
        this.isJumping = packet.readBoolean();
        this.xRot = (float)packet.readDouble();
        this.yRot = (float)packet.readDouble();
    }

    public void handle(NetworkMessage.NetworkContext networkContext) {
        if (EnvironmentHelper.isServerEnvironment()) {
            Player player = networkContext.player;
            if (player.vehicle instanceof AetherRideable) {
                AetherRideable vehicle = (AetherRideable)player.vehicle;
                vehicle.controlEntity(this.moveForward, this.moveStrafe, this.isJumping, this.xRot, this.yRot);
            } else if (player.passenger instanceof AetherRideable) {
                AetherRideable vehicle = (AetherRideable)player.passenger;
                vehicle.controlEntity(this.moveForward, this.moveStrafe, this.isJumping, this.xRot, this.yRot);
            }
        }
    }
}

