/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.net.message;

import java.util.Optional;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import org.jspecify.annotations.NonNull;
import teamport.aether.AetherMod;
import teamport.aether.entity.boss.AetherBossList;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class BossListNetworkMessage
implements NetworkMessage {
    private Type type;
    private int entityID;

    public static BossListNetworkMessage clear() {
        BossListNetworkMessage e = new BossListNetworkMessage();
        e.type = Type.CLEAR;
        e.entityID = -1;
        return e;
    }

    public BossListNetworkMessage() {
    }

    public BossListNetworkMessage(Type type, Entity entity) {
        this.type = type;
        this.entityID = entity.id;
    }

    public void encodeToUniversalPacket(@NonNull UniversalPacket packet) {
        packet.writeInt(this.type.ordinal());
        packet.writeInt(this.entityID);
    }

    public void decodeFromUniversalPacket(@NonNull UniversalPacket packet) {
        this.type = Type.values()[packet.readInt()];
        this.entityID = packet.readInt();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!EnvironmentHelper.isClientWorld()) {
            return;
        }
        AetherMod.LOGGER.info("Received BossList update message.");
        Player player = context.player;
        if (player.world != null && this.type != Type.CLEAR) {
            Optional<Entity> entityOption = player.world.getLoadedEntityList().stream().filter(e -> e.id == this.entityID).findFirst();
            if (!entityOption.isPresent()) {
                AetherMod.LOGGER.error("Couldn't find boss to add to list.");
                return;
            }
            Entity entity = entityOption.get();
            if (this.type == Type.ADD) {
                ((AetherBossList)player).aether$TryAddBossList((Mob)entity);
            } else {
                ((AetherBossList)player).aether$removeFromBossList((Mob)entity);
            }
        } else {
            ((AetherBossList)player).aether$clearBossList();
        }
    }

    public static enum Type {
        CLEAR,
        ADD,
        REMOVE;

    }
}

