/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.chunk;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSand;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.noise.BasePerlinNoise;
import net.minecraft.core.world.noise.PerlinNoise;
import net.minecraft.core.world.noise.PerlinSimplexNoise;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.blocks.terrain.BlockLogicOreAmbrosium;
import teamport.aether.blocks.terrain.BlockLogicOreGravitite;
import teamport.aether.blocks.terrain.BlockLogicOreZanite;
import teamport.aether.noise.Worley;
import teamport.aether.world.feature.dungeon.bronze.WorldFeatureAetherBronzeDungeon;
import teamport.aether.world.feature.dungeon.gold.WorldFeatureAetherGoldDungeon;
import teamport.aether.world.feature.dungeon.silver.WorldFeatureAetherSilverDungeon;
import teamport.aether.world.feature.terrain.WorldFeatureAetherClouds;
import teamport.aether.world.feature.terrain.WorldFeatureAetherCloudsFlat;
import teamport.aether.world.feature.terrain.WorldFeatureAetherLiquid;
import teamport.aether.world.feature.terrain.WorldFeatureAetherOre;
import teamport.aether.world.feature.terrain.WorldFeatureAetherQuicksoil;
import teamport.aether.world.feature.terrain.WorldFeatureAetherTree;
import teamport.aether.world.feature.terrain.WorldFeatureAetherTreeGoldenOak;
import teamport.aether.world.type.AetherWorldTypes;

public class ChunkDecoratorAether
implements ChunkDecorator {
    private final World world;
    private final BasePerlinNoise<?> flowerVeinNoise;
    private final BasePerlinNoise<?> flowerDensityNoise;
    private final PerlinSimplexNoise cloudNoise;
    private final BasePerlinNoise<?> cloudNoise2;
    private static final double[] CLOUD_NOISE_BUFFER = new double[256];
    private static final double[] CLOUD_NOISE_2_BUFFER = new double[256];
    private static final double[] CLOUD_NOISE_TOP_BUFFER = new double[256];
    private static final double[] CLOUD_NOISE_TOP_2_BUFFER = new double[256];
    private static final int[] FLOWERS = new int[]{AetherBlocks.FLOWER_WHITE.id(), AetherBlocks.FLOWER_PURPLE.id()};
    private static final int[] META_ID = new int[]{0, 16, 32, 48};
    private static final double[] FLOWER_DENSITY_NOISE_BUFFER = new double[256];
    private static final double[] FLOWER_VEIN_NOISE_BUFFER = new double[64];
    public static final WorldFeatureAetherQuicksoil QUICKSOIL = new WorldFeatureAetherQuicksoil(AetherBlocks.QUICKSOIL.id());
    public static final WorldFeatureAetherTreeGoldenOak TREE_GOLDEN = new WorldFeatureAetherTreeGoldenOak();
    public static final WorldFeatureAetherTree TREE_SKYROOT = new WorldFeatureAetherTree(AetherBlocks.LEAVES_SKYROOT.id(), AetherBlocks.LOG_SKYROOT.id(), 4);
    public static final WorldFeatureAetherLiquid WATERFALL = new WorldFeatureAetherLiquid(Blocks.FLUID_WATER_FLOWING.id());
    public static final WorldFeatureAetherClouds AERCLOUD_WHITE = new WorldFeatureAetherClouds(AetherBlocks.AERCLOUD_WHITE.id(), 16);
    public static final WorldFeatureAetherClouds AERCLOUD_BLUE = new WorldFeatureAetherClouds(AetherBlocks.AERCLOUD_BLUE.id(), 8);
    public static final WorldFeatureAetherClouds AERCLOUD_GOLD = new WorldFeatureAetherClouds(AetherBlocks.AERCLOUD_GOLD.id(), 4);
    public static final WorldFeatureAetherCloudsFlat AERCLOUD_FLAT = new WorldFeatureAetherCloudsFlat(AetherBlocks.AERCLOUD_WHITE.id(), 48);
    public static final WorldFeatureAetherOre ORE_DIRT = new WorldFeatureAetherOre(AetherBlocks.DIRT_AETHER.id(), 32);
    public static final WorldFeatureAetherOre ORE_ICESTONE = new WorldFeatureAetherOre(AetherBlocks.ICESTONE.id(), 32);
    public static final WorldFeatureAetherOre ORE_AMBROSIUM = new WorldFeatureAetherOre(BlockLogicOreAmbrosium.variantMap, 16);
    public static final WorldFeatureAetherOre ORE_ZANITE = new WorldFeatureAetherOre(BlockLogicOreZanite.variantMap, 8);
    public static final WorldFeatureAetherOre ORE_GRAVITITE = new WorldFeatureAetherOre(BlockLogicOreGravitite.variantMap, 7);

    public ChunkDecoratorAether(World world) {
        this.world = world;
        this.flowerVeinNoise = new PerlinNoise(world.getRandomSeed(), 4, 44);
        this.flowerDensityNoise = new PerlinNoise(world.getRandomSeed(), 4, 44);
        this.cloudNoise = new PerlinSimplexNoise(new Random(world.getRandomSeed()), 4);
        this.cloudNoise2 = new PerlinNoise(world.getRandomSeed() * 31L ^ 7L, 4, 44);
    }

    private static Random deriveRandomFromWorld(Chunk chunk, long seed) {
        Random rand = new Random(seed);
        long l1 = rand.nextLong() / 2L * 2L + 1L;
        long l2 = rand.nextLong() / 2L * 2L + 1L;
        rand.setSeed((long)chunk.xPosition * l1 + (long)chunk.zPosition * l2 ^ seed);
        return rand;
    }

    public void decorate(Chunk chunk) {
        this.world.scheduledUpdatesAreImmediate = true;
        BlockLogicSand.fallInstantly = true;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int worldX = chunk.xPosition * 16;
        int worldZ = chunk.zPosition * 16;
        Random rand = ChunkDecoratorAether.deriveRandomFromWorld(chunk, this.world.getRandomSeed());
        this.decorateWithClouds(rand, worldX, worldZ);
        if (this.world.getWorldType() == AetherWorldTypes.AETHER_EXTENDED) {
            this.decorateWithFlatClouds(chunk);
        }
        this.decorateWithFlowers(chunk, rand);
        this.decorateWithQuickSoil(rand, worldX, worldZ, minY, maxY);
        this.decorateWithLakesAndTrees(rand, minY, maxY, worldX, worldZ);
        if ((chunk.xPosition & 1) == 0 && (chunk.zPosition & 1) == 0) {
            this.decorateWithDungeons(chunk, rand, minY, maxY);
        }
        this.decorateWithOres(rand, minY, maxY, worldX, worldZ);
        BlockLogicSand.fallInstantly = false;
        this.world.scheduledUpdatesAreImmediate = false;
    }

    public void decorateWithFlatClouds(Chunk chunk) {
        double scale = 0.38;
        this.cloudNoise.getValue(CLOUD_NOISE_BUFFER, (double)chunk.xPosition * 16.0, (double)chunk.zPosition * 16.0, 16, 16, scale * 0.627, scale * 2.0, 0.0);
        this.cloudNoise2.get(CLOUD_NOISE_2_BUFFER, (double)chunk.xPosition * 16.0, (double)chunk.zPosition * 16.0 - 32.0, 0.0, 16, 16, 1, scale * 0.627, scale * 0.627, scale * 2.0);
        this.cloudNoise.getValue(CLOUD_NOISE_TOP_BUFFER, (double)chunk.xPosition * 16.0 + 32.0, (double)chunk.zPosition * 16.0 + 32.0, 16, 16, scale * 0.627, scale * 2.0, 0.0);
        this.cloudNoise2.get(CLOUD_NOISE_TOP_2_BUFFER, (double)chunk.xPosition * 16.0 + 48.0, (double)chunk.zPosition * 16.0 + 32.0, 0.0, 16, 16, 1, scale * 0.627, scale * 0.627, scale * 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int cloudDensity = (int)Math.min(Math.abs(CLOUD_NOISE_2_BUFFER[z + x * 16] + CLOUD_NOISE_BUFFER[z + x * 16]) * 6.0 - 32.0, 2.0);
                for (int y = 0; y < cloudDensity; ++y) {
                    if (chunk.getBlockID(x, 24 + y, z) != 0) continue;
                    chunk.setBlockID(x, 24 + y, z, AetherBlocks.AERCLOUD_WHITE.id());
                }
                int cloudDensity2 = (int)Math.min(Math.abs(CLOUD_NOISE_TOP_2_BUFFER[z + x * 16] + CLOUD_NOISE_TOP_BUFFER[z + x * 16]) * 6.0 - 40.0, 1.0);
                for (int y = 0; y < cloudDensity2; ++y) {
                    if (chunk.getBlockID(x, 14 + y, z) != 0) continue;
                    chunk.setBlockID(x, 14 + y, z, AetherBlocks.AERCLOUD_WHITE.id());
                }
            }
        }
    }

    public void decorateWithFlowers(Chunk chunk, Random rand) {
        double beachScale = 0.03125;
        this.flowerDensityNoise.get(FLOWER_DENSITY_NOISE_BUFFER, (double)chunk.xPosition * 16.0, (double)chunk.zPosition * 16.0, 0.0, 16, 16, 1, beachScale * 1.5, beachScale * 1.5, beachScale * 1.5);
        this.flowerVeinNoise.get(FLOWER_VEIN_NOISE_BUFFER, (double)chunk.xPosition * 16.0, (double)chunk.zPosition * 16.0, 0.0, 8, 8, 1, beachScale * 0.627, beachScale * 0.627, beachScale * 0.627);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int flowerMeta;
                int flowerID;
                Block blk;
                double noise = MathHelper.clamp((double)(Math.abs(FLOWER_DENSITY_NOISE_BUFFER[z + x * 8]) / 16.0), (double)0.0, (double)1.0);
                int clumpRadius = 64;
                double influence = MathHelper.clamp((float)Worley.sampleAt(chunk.xPosition * 16 + x, chunk.zPosition * 16 + z, 16, Worley.mix((int)(this.world.getRandomSeed() >>> 32), (int)(this.world.getRandomSeed() & 0xFFFFFFFFL), 0)), (float)(-clumpRadius), (float)clumpRadius) / (float)clumpRadius;
                double flowerDensityFloat = noise * -1.0 / influence * -1.0;
                int flowerDensity = (int)(MathHelper.clamp((double)flowerDensityFloat, (double)0.0, (double)1.0) * 16.0);
                flowerDensity -= 8;
                int blockY = chunk.getHeightValue(x, z);
                if (blockY >= this.world.getWorldType().getMaxY() || (blk = Blocks.getBlock((int)chunk.getBlockID(x, blockY - 1, z))) == null || !blk.hasTag(AetherBlockTags.GROWS_AETHER_FLOWERS)) continue;
                if (flowerDensity < 0) {
                    if (rand.nextInt(128) == 0) {
                        chunk.setBlockIDWithMetadataRaw(x, blockY, z, FLOWERS[rand.nextInt(FLOWERS.length)], META_ID[rand.nextInt(META_ID.length)]);
                    }
                    if (this.world.getWorldType() == AetherWorldTypes.AETHER_RETRO || rand.nextInt(16) != 0) continue;
                    chunk.setBlockID(x, blockY, z, AetherBlocks.TALLGRASS_AETHER.id());
                    continue;
                }
                if (rand.nextInt(3 * (9 - flowerDensity)) != 0) continue;
                if (rand.nextInt(2) == 0) {
                    flowerID = FLOWERS[(int)Math.abs(FLOWER_VEIN_NOISE_BUFFER[z / 2 + x / 2 * 8] * 8.0) % FLOWERS.length];
                    flowerMeta = META_ID[rand.nextInt(META_ID.length)];
                } else {
                    flowerID = this.world.getWorldType() != AetherWorldTypes.AETHER_RETRO ? AetherBlocks.TALLGRASS_AETHER.id() : 0;
                    flowerMeta = 0;
                }
                chunk.setBlockIDWithMetadataRaw(x, blockY, z, flowerID, flowerMeta);
            }
        }
    }

    public void decorateWithQuickSoil(Random rand, int worldX, int worldZ, int minY, int maxY) {
        int rangeY = maxY + 1 - minY;
        if (rand.nextInt(5) == 0) {
            block0: for (int yPosition = minY + rangeY / 8; yPosition < minY + (int)(0.75f * (float)rangeY); ++yPosition) {
                for (int xPosition = worldX; xPosition < worldX + 16; ++xPosition) {
                    for (int zPosition = worldZ; zPosition < worldZ + 16; ++zPosition) {
                        if (this.world.getBlockId(xPosition, yPosition, zPosition) != 0 || this.world.getBlockId(xPosition, yPosition + 1, zPosition) != AetherBlocks.GRASS_AETHER.id() || this.world.getBlockId(xPosition, yPosition + 2, zPosition) != 0) continue;
                        QUICKSOIL.place(this.world, rand, xPosition, yPosition, zPosition);
                        continue block0;
                    }
                }
            }
        }
    }

    public void decorateWithLakesAndTrees(Random rand, int minY, int maxY, int x, int z) {
        int generateChance;
        int y;
        int rangeY = maxY + 1 - minY;
        x += rand.nextInt(12) + 2;
        z += rand.nextInt(12) + 2;
        if (rand.nextInt(8) == 0) {
            y = rand.nextInt(rangeY);
            new WorldFeatureLake(Blocks.FLUID_WATER_STILL.id()).place(this.world, rand, x, y, z);
        }
        for (generateChance = 0; generateChance < 2; ++generateChance) {
            (rand.nextInt(18) == 0 ? TREE_GOLDEN : TREE_SKYROOT).place(this.world, rand, x, this.world.getHeightValue(x, z), z);
        }
        for (generateChance = 0; generateChance < 50; ++generateChance) {
            y = rand.nextInt(rangeY - 1);
            WATERFALL.place(this.world, rand, x, y, z);
        }
    }

    public void decorateWithClouds(Random rand, int worldX, int worldZ) {
        int yPosition;
        if (rand.nextInt(12) == 0) {
            yPosition = rand.nextInt(32) + 224;
            AERCLOUD_GOLD.place(this.world, rand, worldX + 8, yPosition, worldZ + 8);
        }
        if (rand.nextInt(12) == 0) {
            yPosition = rand.nextInt(64) + 128;
            AERCLOUD_BLUE.place(this.world, rand, worldX + 8, yPosition, worldZ + 8);
        }
        if (rand.nextInt(6) == 0) {
            yPosition = rand.nextInt(192) + 32;
            AERCLOUD_WHITE.place(this.world, rand, worldX + 8, yPosition, worldZ + 8);
        }
        if ((this.world.getWorldType() == AetherWorldTypes.AETHER_DEFAULT || this.world.getWorldType() == AetherWorldTypes.AETHER_RETRO) && rand.nextInt(24) == 0) {
            yPosition = rand.nextInt(32) + 4;
            AERCLOUD_FLAT.place(this.world, rand, worldX + 8, yPosition, worldZ + 8);
        }
    }

    public void decorateWithOres(Random rand, int minY, int maxY, int worldX, int worldZ) {
        int z;
        int x;
        int y;
        int rangeY = maxY + 1 - minY;
        float oreHeightModifier = (float)rangeY / 128.0f;
        int generateChance = 0;
        while ((float)generateChance < 10.0f * oreHeightModifier) {
            y = rand.nextInt(rangeY);
            x = worldX + rand.nextInt(16);
            z = worldZ + rand.nextInt(16);
            ORE_DIRT.place(this.world, rand, x, y, z);
            ++generateChance;
        }
        generateChance = 0;
        while ((float)generateChance < 10.0f * oreHeightModifier) {
            y = rand.nextInt(rangeY);
            x = worldX + rand.nextInt(16);
            z = worldZ + rand.nextInt(16);
            ORE_ICESTONE.place(this.world, rand, x, y, z);
            ++generateChance;
        }
        generateChance = 0;
        while ((float)generateChance < 20.0f * oreHeightModifier) {
            y = rand.nextInt(rangeY);
            x = worldX + rand.nextInt(16);
            z = worldZ + rand.nextInt(16);
            ORE_AMBROSIUM.place(this.world, rand, x, y, z);
            ++generateChance;
        }
        generateChance = 0;
        while ((float)generateChance < 15.0f * oreHeightModifier) {
            y = rand.nextInt(rangeY / 2);
            x = worldX + rand.nextInt(16);
            z = worldZ + rand.nextInt(16);
            ORE_ZANITE.place(this.world, rand, x, y, z);
            ++generateChance;
        }
        generateChance = 0;
        while ((float)generateChance < 8.0f * oreHeightModifier) {
            y = rand.nextInt(rangeY / 3);
            x = worldX + rand.nextInt(16);
            z = worldZ + rand.nextInt(16);
            ORE_GRAVITITE.place(this.world, rand, x, y, z);
            ++generateChance;
        }
    }

    public void decorateWithDungeons(Chunk chunk, Random rand, int minY, int maxY) {
        int chunkX = chunk.xPosition;
        int chunkZ = chunk.zPosition;
        int rangeY = maxY + 1 - minY;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        int gridX = MathHelper.floor((double)((float)chunkX / 2.0f));
        int gridZ = MathHelper.floor((double)((float)chunkZ / 2.0f));
        long worldSeed = this.world.getRandomSeed();
        int transformedSeed = Worley.mix((int)(worldSeed >>> 32), (int)(worldSeed & 0xFFFFFFFFL), 0);
        int goldSeed = Worley.isSeed(gridX, gridZ, 11, transformedSeed, 1, 1);
        int silverSeed = Worley.isSeed(gridX, gridZ, 10, transformedSeed, 1, 1);
        int bronzeSeed = Worley.isSeed(gridX, gridZ, 4, transformedSeed, 1, 0);
        if (goldSeed > -1) {
            int dungeonZ;
            int dungeonY;
            WorldFeatureAetherGoldDungeon goldDungeon = new WorldFeatureAetherGoldDungeon(rand);
            int dungeonX = x + rand.nextInt(16);
            if (goldDungeon.canPlace(this.world, dungeonX, dungeonY = rangeY / 2 + rand.nextInt(rangeY / 8), dungeonZ = z + rand.nextInt(16))) {
                goldDungeon.register(this.world, worldSeed ^ rand.nextLong(), dungeonX, dungeonY, dungeonZ);
            }
        } else if (silverSeed > -1) {
            int dungeonZ;
            WorldFeatureAetherSilverDungeon silverDungeon = new WorldFeatureAetherSilverDungeon(rand);
            int dungeonX = x - 15;
            int dungeonY = (int)((double)rangeY - (double)rangeY / 4.5 + (double)rand.nextInt(rangeY / 8));
            if (silverDungeon.canPlace(this.world, dungeonX, dungeonY, dungeonZ = z + 28)) {
                silverDungeon.register(this.world, worldSeed ^ rand.nextLong(), dungeonX, dungeonY, dungeonZ);
            }
        } else if (bronzeSeed > -1) {
            int dungeonX = x + rand.nextInt(16);
            int dungeonZ = z + rand.nextInt(16);
            int maxDepth = 0;
            int maxDepthStart = 0;
            int currentDepth = 0;
            int currentStart = 0;
            for (int i = this.world.worldType.getMinY(); i < this.world.worldType.getMaxY(); ++i) {
                if (this.world.getBlockId(dungeonX, i, dungeonZ) != 0) {
                    ++currentDepth;
                } else {
                    currentDepth = 0;
                    currentStart = i;
                }
                if (currentDepth <= maxDepth) continue;
                maxDepth = currentDepth;
                maxDepthStart = currentStart;
            }
            int dungeonY = Math.max(0, maxDepthStart + maxDepth / 2 - (int)(0.01953125f * (float)rangeY));
            new WorldFeatureAetherBronzeDungeon().place(this.world, rand, dungeonX, dungeonY, dungeonZ);
        }
    }
}

