/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import teamport.aether.AetherMod;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.compat.AetherPlugin;
import teamport.aether.helper.AetherMathHelper;
import teamport.aether.helper.unboxed.PriorityEntry;
import teamport.aether.items.AetherItems;
import teamport.aether.world.AetherDimension;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.dungeon.bronze.component.BossRoom;
import teamport.aether.world.feature.dungeon.bronze.component.DisplayRoom;
import teamport.aether.world.feature.dungeon.bronze.component.HallwayRoom;
import teamport.aether.world.feature.dungeon.bronze.component.JumpRoom;
import teamport.aether.world.feature.dungeon.bronze.component.SpikerRoom;
import teamport.aether.world.feature.dungeon.bronze.component.StairwellRoom;
import teamport.aether.world.feature.dungeon.bronze.component.TallRoom;
import teamport.aether.world.feature.dungeon.bronze.component.TreasureRoom;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class WorldFeatureAetherBronzeDungeon
extends WorldFeature {
    private static final float MAX_WEIGHT = 40.0f;
    private static final int TUNNEL_WIDTH = 6;
    private static final int TUNNEL_COUNT = 4;
    private static final int TUNNEL_MAX_LENGTH = 100;
    private World world;
    private Random random;
    public static final BlockPallet carvedHolystone = new BlockPallet();
    public static final BlockPallet lockedCarvedHolystone = new BlockPallet();
    public static final BlockPallet holystone = new BlockPallet();
    public static final BlockPallet chestsOrMimic = new BlockPallet();
    public static final WeightedRandomBag<WeightedRandomLootObject> ARMOR;
    public static final WeightedRandomBag<WeightedRandomLootObject> JUNK;
    public static final WeightedRandomBag<WeightedRandomLootObject> AMMO;
    public static final WeightedRandomBag<WeightedRandomLootObject> GADGET;
    public static final WeightedRandomBag<WeightedRandomLootObject> FOOD;
    public static final WeightedRandomBag<WeightedRandomLootObject> TREASURE;
    private static final RoomManager MANAGER;
    private static final WeightedRandomBag<Supplier<? extends BaseBronzeRoom>> TREASURE_ROOMS;

    public boolean place(World world, Random random, int x, int y, int z) {
        this.world = world;
        this.random = random;
        HashSet<BaseBronzeRoom> seenRooms = new HashSet<BaseBronzeRoom>();
        ArrayList<BaseBronzeRoom> availableRooms = new ArrayList<BaseBronzeRoom>();
        BossRoom boss = new BossRoom();
        if (world.canBlockSeeTheSky(x, y, z) || !boss.place(world, random, x, y, z)) {
            return false;
        }
        float roomWeight = boss.getRoomWeight();
        int bossRoomCount = 1;
        seenRooms.add(boss);
        availableRooms.add(boss);
        BaseBronzeRoom currentRoom = null;
        while (!availableRooms.isEmpty() && 40.0f > roomWeight) {
            List<BaseBronzeRoom.Door> listDoor;
            if (currentRoom == null) {
                currentRoom = (BaseBronzeRoom)((Object)availableRooms.get(random.nextInt(availableRooms.size())));
            }
            if ((listDoor = currentRoom.getAvailableDoors()).isEmpty()) {
                availableRooms.remove((Object)currentRoom);
                currentRoom = null;
                continue;
            }
            Iterator bagDoors = this.makeRoomBag(listDoor);
            BaseBronzeRoom.Door door = (BaseBronzeRoom.Door)bagDoors.getRandom(random);
            BaseBronzeRoom nextRoom = MANAGER.getRoom(random).get();
            if (nextRoom instanceof BossRoom && (float)(++bossRoomCount) / roomWeight > 0.65f) {
                nextRoom = (BaseBronzeRoom)((Object)((Supplier)TREASURE_ROOMS.getRandom(random)).get());
            }
            WorldFeaturePoint nextDoor = WorldFeaturePoint.wfp(0, 0, 0).moveInDirection(door.getHeading()).multiply(6).add(door.getP1());
            List<WorldFeaturePoint> listAnchor = nextRoom.getAnchors(nextDoor, door.getHeading());
            Collections.shuffle(listAnchor, random);
            for (WorldFeaturePoint anchor : listAnchor) {
                if (this.intercept(seenRooms, nextRoom, anchor)) {
                    currentRoom.markDoor(door, BaseBronzeRoom.ClosingType.INTERCEPT);
                    currentRoom = null;
                    break;
                }
                if (!nextRoom.place(world, random, anchor.getX(), anchor.getY(), anchor.getZ())) continue;
                WorldFeaturePoint bottomCorner = door.getP1().copy();
                WorldFeaturePoint topCorner = WorldFeatureAetherBronzeDungeon.getTopCornerPoint(seenRooms, nextRoom, nextDoor, door);
                this.createTunnel(bottomCorner, topCorner, door.getHeading());
                roomWeight += nextRoom.getRoomWeight();
                seenRooms.add(nextRoom);
                availableRooms.add(nextRoom);
                currentRoom.markDoor(door, BaseBronzeRoom.ClosingType.PLACED);
                nextRoom.markDoor(nextRoom.getDoor(nextDoor), BaseBronzeRoom.ClosingType.PLACED);
                currentRoom = nextRoom;
                break;
            }
            if (currentRoom == null) continue;
            currentRoom.markDoor(door, BaseBronzeRoom.ClosingType.NO_SPACE);
        }
        PriorityQueue<PriorityEntry<BaseBronzeRoom.Door>> tunnels = new PriorityQueue<PriorityEntry<BaseBronzeRoom.Door>>();
        for (BaseBronzeRoom room : seenRooms) {
            List<BaseBronzeRoom.Door> listDoor = room.getAdjustedDoors();
            if (room instanceof BossRoom && seenRooms.size() < 4) {
                BaseBronzeRoom.Door d = listDoor.get(random.nextInt(listDoor.size()));
                listDoor = new ArrayList<BaseBronzeRoom.Door>();
                listDoor.add(d);
                room.markDoor(d, BaseBronzeRoom.ClosingType.PLACED);
            }
            if (room instanceof HallwayRoom) continue;
            for (BaseBronzeRoom.Door door : listDoor) {
                if (door.getMark() != BaseBronzeRoom.ClosingType.OPEN && door.getMark() != BaseBronzeRoom.ClosingType.NO_SPACE && !(room instanceof BossRoom)) continue;
                AetherMod.LOGGER.debug("door type:{}, door heading:{}", (Object)door.getMark(), (Object)door.getHeading());
                WorldFeaturePoint p1 = door.getP1().copy();
                WorldFeaturePoint p2 = door.getP2().copy();
                while (!this.breaksSurface(p1, p2) && p1.distanceTo(door.getP1()) < 100.0 && y > 5 && y < world.getHeightBlocks()) {
                    p1.moveInDirection(door.getHeading());
                    p2.moveInDirection(door.getHeading());
                }
                if (seenRooms.stream().anyMatch(r -> r.intercept(p1))) continue;
                tunnels.add(PriorityEntry.pEntry(p1.distanceTo(door.getP1()) * (double)WorldFeatureAetherBronzeDungeon.bias(door.getHeading()), BaseBronzeRoom.Door.door(door.getHeading(), p1.moveInDirection(door.getHeading()), door.getP2().copy().moveInDirection(door.getHeading().getOpposite()))));
            }
        }
        if (tunnels.isEmpty()) {
            AetherMod.LOGGER.debug("No exit tunnels are generating for this bronze dungeon at {} {} {}", new Object[]{x, y, z});
            return true;
        }
        int tunnelAmount = tunnels.size() > 4 ? 4 : tunnels.size();
        for (int i = 0; i < tunnelAmount; ++i) {
            PriorityEntry entry = (PriorityEntry)tunnels.peek();
            tunnels.remove(entry);
            if (entry == null) continue;
            BaseBronzeRoom.Door door = (BaseBronzeRoom.Door)entry.getData();
            AetherMod.LOGGER.debug("Tunnel distance:{}, p1:{}, p2:{}, direction:{}.", new Object[]{entry.getWeight(), door.getP1(), door.getP2(), door.getHeading()});
            this.createTunnel(door.getP1(), door.getP2(), door.getHeading());
        }
        return true;
    }

    public void createTunnel(WorldFeaturePoint bottomCorner, WorldFeaturePoint topCorner, Direction direction) {
        if (this.world.dimension.equals(AetherDimension.getAether())) {
            WorldFeaturePoint liningBottomCorner = bottomCorner.copy();
            WorldFeaturePoint liningTopCorner = topCorner.copy();
            WorldFeatureAetherBronzeDungeon.adjustCornerForLining(direction, liningBottomCorner, liningTopCorner);
            WorldFeatureAetherBronzeDungeon.placeWorldLining(this.world, WorldFeatureComponent.drawVolumeWithPoint(this.random, holystone, liningBottomCorner, liningTopCorner, false));
        }
        WorldFeatureComponent.drawVolumeWithPoint(0, 0, bottomCorner, topCorner, false).place(this.world);
    }

    public static void placeWorldLining(World world, WorldFeatureComponent lining) {
        for (WorldFeatureBlock block : lining.getBlockList()) {
            if (!BaseBronzeRoom.roomCanReplace(world, block) || block.getY() <= 5 || block.getY() > world.getHeightBlocks()) continue;
            block.place(world);
        }
    }

    public static void adjustCornerForLining(Direction direction, WorldFeaturePoint liningBottomCorner, WorldFeaturePoint liningTopCorner) {
        if (direction.isHorizontal()) {
            liningBottomCorner.moveInDirection(Direction.DOWN);
            liningTopCorner.moveInDirection(Direction.UP);
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                liningBottomCorner.moveInDirection(Direction.WEST);
                liningTopCorner.moveInDirection(Direction.EAST);
            } else {
                liningBottomCorner.moveInDirection(Direction.NORTH);
                liningTopCorner.moveInDirection(Direction.SOUTH);
            }
        } else if (direction == Direction.UP) {
            liningBottomCorner.moveInDirection(Direction.NORTH).moveInDirection(Direction.WEST);
            liningTopCorner.moveInDirection(Direction.SOUTH).moveInDirection(Direction.EAST);
        } else {
            liningBottomCorner.moveInDirection(Direction.SOUTH).moveInDirection(Direction.EAST);
            liningTopCorner.moveInDirection(Direction.NORTH).moveInDirection(Direction.WEST);
        }
    }

    private static WorldFeaturePoint getTopCornerPoint(Set<BaseBronzeRoom> seenRooms, BaseBronzeRoom nextRoom, WorldFeaturePoint nextDoor, BaseBronzeRoom.Door door) {
        WorldFeaturePoint point = nextRoom.getDoor(nextDoor).getP2().copy().moveInDirection(door.getHeading());
        if (seenRooms.size() == 1) {
            return point.moveInDirection(Direction.DOWN, 2);
        }
        return point;
    }

    private boolean intercept(Set<BaseBronzeRoom> seen, BaseBronzeRoom nextRoom, WorldFeaturePoint anchor) {
        for (BaseBronzeRoom room : seen) {
            if (!room.intercept(anchor, nextRoom)) continue;
            return true;
        }
        return false;
    }

    private boolean breaksSurface(WorldFeaturePoint p1, WorldFeaturePoint p2) {
        WorldFeatureComponent door = WorldFeatureComponent.drawVolume(0, 0, p1, p2, false);
        int count = 0;
        for (WorldFeaturePoint worldFeaturePoint : door.getBlockList()) {
            Material blockMaterial;
            Block block = this.world.getBlock(worldFeaturePoint.getX(), worldFeaturePoint.getY(), worldFeaturePoint.getZ());
            int blockID = block == null ? 0 : block.id();
            Material material = blockMaterial = block == null ? Material.air : block.getMaterial();
            if (blockID != 0 && !blockMaterial.isLiquid()) continue;
            ++count;
        }
        return count >= door.getBlockList().size();
    }

    private WeightedRandomBag<BaseBronzeRoom.Door> makeRoomBag(List<BaseBronzeRoom.Door> listDoor) {
        WeightedRandomBag bag = new WeightedRandomBag();
        for (BaseBronzeRoom.Door door : listDoor) {
            if (door.getHeading() == Direction.UP || door.getHeading() == Direction.DOWN) {
                bag.addEntry((Object)door, 1.0);
                continue;
            }
            bag.addEntry((Object)door, 4.0);
        }
        return bag;
    }

    public static float bias(Direction direction) {
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return 4.0f;
        }
        return 1.0f;
    }

    public static List<ItemStack> generateLoot(Random random) {
        int i;
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        int count = random.nextInt(3) + 8;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)JUNK.getRandom(random)).getItemStack());
        }
        count = random.nextInt(4) + 2;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)AMMO.getRandom(random)).getItemStack());
        }
        count = random.nextInt(3) + 2;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)FOOD.getRandom(random)).getItemStack());
        }
        count = AetherMathHelper.invertedExponentialCapped(random, 0.5f, 2) + 1;
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)ARMOR.getRandom(random)).getItemStack());
        }
        count = AetherMathHelper.invertedExponentialCapped(random, 0.5f, 2);
        for (i = 0; i < count; ++i) {
            loot.add(((WeightedRandomLootObject)GADGET.getRandom(random)).getItemStack());
        }
        return loot;
    }

    static {
        carvedHolystone.addEntry(AetherBlocks.CARVED_STONE.id(), 85.0);
        carvedHolystone.addEntry(AetherBlocks.CARVED_STONE_LIGHT.id(), 5.0);
        carvedHolystone.addEntry(AetherBlocks.CARVED_STONE_TRAPPED.id(), 10.0);
        lockedCarvedHolystone.addEntry(AetherBlocks.CARVED_STONE_LOCKED.id(), 85.0);
        lockedCarvedHolystone.addEntry(AetherBlocks.CARVED_STONE_LIGHT_LOCKED.id(), 5.0);
        holystone.addEntry(AetherBlocks.COBBLE_HOLYSTONE.id(), 90.0);
        holystone.addEntry(AetherBlocks.COBBLE_HOLYSTONE_MOSSY.id(), 10.0);
        chestsOrMimic.addEntry(0, 1.0);
        chestsOrMimic.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT.id(), 1.0);
        chestsOrMimic.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT.id(), 1.0);
        ARMOR = new WeightedRandomBag();
        JUNK = new WeightedRandomBag();
        AMMO = new WeightedRandomBag();
        GADGET = new WeightedRandomBag();
        FOOD = new WeightedRandomBag();
        JUNK.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMBROSIUM.getDefaultStack(), 1, 6), 4.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.TORCH_AMBROSIUM.getDefaultStack(), 1, 4), 4.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.HOLYSTONE.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.HOLYSTONE_MOSSY.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.ICESTONE.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.CARVED_STONE_LIGHT.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherBlocks.CARVED_STONE.getDefaultStack(), 4, 12), 2.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.BUCKET_SKYROOT.getDefaultStack()), 1.0);
        JUNK.addEntry((Object)new WeightedRandomLootObject(AetherItems.ZANITE.getDefaultStack(), 1, 4), 1.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(AetherItems.FOOD_HEALING_STONE.getDefaultStack(), 1, 4), 4.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(AetherItems.FOOD_GUMMY_BLUE.getDefaultStack(), 1, 4), 2.0);
        FOOD.addEntry((Object)new WeightedRandomLootObject(AetherItems.FOOD_GUMMY_GOLD.getDefaultStack(), 1, 2), 1.0);
        int minTool = AetherItems.TOOL_PICKAXE_HOLYSTONE.getMaxDamage() / 2;
        int maxTool = AetherItems.TOOL_PICKAXE_HOLYSTONE.getMaxDamage();
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_PICKAXE_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_AXE_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        ARMOR.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SHOVEL_HOLYSTONE.getDefaultStack()).setRandomMetadata(minTool, maxTool), 1.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(null), 8.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_GOLDEN.getDefaultStack(), 2, 6), 4.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_POISON.getDefaultStack(), 2, 6), 2.0);
        AMMO.addEntry((Object)new WeightedRandomLootObject(AetherItems.AMMO_DART_ENCHANTED.getDefaultStack(), 2, 6), 1.0);
        GADGET.addEntry((Object)new WeightedRandomLootObject(null), 4.0);
        GADGET.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_LEATHER.getDefaultStack()), 3.0);
        GADGET.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_ZANITE.getDefaultStack()), 1.0);
        TREASURE = new WeightedRandomBag();
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.RECORD_MORNING.getDefaultStack()), 1.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_HAMMER_NOTCH.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_KNIFE_LIGHTNING.getDefaultStack(), 8, 16), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.TOOL_SWORD_LIGHTNING.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_TALISMAN_REGEN.getDefaultStack()), 10.0);
        TREASURE.addEntry((Object)new WeightedRandomLootObject(AetherItems.ARMOR_CAPE_SWET.getDefaultStack()), 10.0);
        MANAGER = new RoomManager();
        FabricLoader.getInstance().getEntrypointContainers("aether", AetherPlugin.class).forEach(plugin -> ((AetherPlugin)plugin.getEntrypoint()).registerBronzeDungeonRoom(MANAGER));
        WeightedRandomBag boss = new WeightedRandomBag();
        boss.addEntry(BossRoom::new, 1.0);
        TREASURE_ROOMS = new WeightedRandomBag();
        TREASURE_ROOMS.addEntry(TreasureRoom::new, 1.0);
        TREASURE_ROOMS.addEntry(JumpRoom::new, 1.0);
        TREASURE_ROOMS.addEntry(DisplayRoom::new, 1.0);
        WeightedRandomBag trapRooms = new WeightedRandomBag();
        trapRooms.addEntry(SpikerRoom::new, 1.0);
        WeightedRandomBag hallway = new WeightedRandomBag();
        hallway.addEntry(HallwayRoom::new, 10.0);
        hallway.addEntry(StairwellRoom::new, 2.0);
        hallway.addEntry(TallRoom::new, 5.0);
        MANAGER.addBag(TREASURE_ROOMS, 55.0f);
        MANAGER.addBag(hallway, 20.0f);
        MANAGER.addBag(trapRooms, 10.0f);
        MANAGER.addBag(boss, 15.0f);
    }

    public static class RoomManager {
        WeightedRandomBag<Object> bag = new WeightedRandomBag();

        public RoomManager addBag(WeightedRandomBag<?> rooms, float weight) {
            this.bag.addEntry(rooms, (double)weight);
            return this;
        }

        public Supplier<? extends BaseBronzeRoom> getRoom(Random random) {
            Object obj = this.bag.getRandom(random);
            while (obj instanceof WeightedRandomBag) {
                obj = ((WeightedRandomBag)obj).getRandom(random);
            }
            if (!(obj instanceof Supplier)) {
                throw new IllegalStateException("Entry is not of type Supplier: " + obj);
            }
            Object result = ((Supplier)obj).get();
            if (result instanceof BaseBronzeRoom) {
                return (Supplier)obj;
            }
            throw new IllegalStateException("Entry is not instance of BaseBronzeRoom: " + obj);
        }
    }
}

