/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class TallRoom
extends BaseBronzeRoom {
    private static final BlockPallet ROOM_PALLET = new BlockPallet();

    public TallRoom() {
        this.height = 30;
        this.roomWeight = 0.5f;
        this.liquidTolerance = 0.75f;
        this.airTolerance = 0.75f;
        this.bottomLiquidTolerance = 1.0f;
        this.topLiquidTolerance = 1.0f;
        this.bottomAirTolerance = 1.0f;
        this.topAirTolerance = 1.0f;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 1, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 19, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 19, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 19, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 19, 4), Direction.UP, 6, Direction.SOUTH, 4);
    }

    private void makeShell() {
        this.room.add(WorldFeatureComponent.drawShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, this.height, Direction.EAST, this.width, this.x, this.y, this.z, false));
        this.room.add(WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, this.width - 2, Direction.UP, this.height - 2, Direction.EAST, this.width - 2, this.x + 1, this.y + 1, this.z + 1, false));
        ArrayList<WorldFeaturePoint> pillar = new ArrayList<WorldFeaturePoint>();
        pillar.add(WorldFeaturePoint.wfp(this.x + 3, this.y, this.z + 3));
        pillar.add(WorldFeaturePoint.wfp(this.x + 3, this.y, this.z + 7));
        pillar.add(WorldFeaturePoint.wfp(this.x + 7, this.y, this.z + 3));
        pillar.add(WorldFeaturePoint.wfp(this.x + 7, this.y, this.z + 7));
        Collections.shuffle(pillar, this.random);
        int pillarheight = this.height - 10;
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            index %= 4;
            WorldFeaturePoint point = (WorldFeaturePoint)pillar.get(index++);
            this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, point.getX(), this.y + pillarheight, point.getZ(), false));
            if (pillarheight < 6) {
                this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, Direction.DOWN, pillarheight, point.getX(), this.y + pillarheight, point.getZ(), false));
                pillarheight -= 4;
                continue;
            }
            this.decoration.add(WorldFeatureBlock.wfb(point.getX(), this.y - 1 + pillarheight, point.getZ(), AetherBlocks.AERCLOUD_WHITE.id(), 0));
            this.decoration.add(WorldFeatureBlock.wfb(point.getX() + 1, this.y - 1 + pillarheight, point.getZ(), AetherBlocks.AERCLOUD_WHITE.id(), 0));
            this.decoration.add(WorldFeatureBlock.wfb(point.getX(), this.y - 1 + pillarheight, point.getZ() + 1, AetherBlocks.AERCLOUD_WHITE.id(), 0));
            this.decoration.add(WorldFeatureBlock.wfb(point.getX(), this.y - 2 + pillarheight, point.getZ(), AetherBlocks.AERCLOUD_WHITE.id(), 0));
            pillarheight -= 4;
        }
        this.chest.add(WorldFeatureComponent.drawPlane(this.random, CHEST_OR_MIMIC, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 5, this.y + this.height - 4, this.z + 5, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 5, this.y + this.height - 5, this.z + 5, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 5, this.y + this.height - 6, this.z + 5, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 6, this.y + this.height - 6, this.z + 5, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 5, this.y + this.height - 6, this.z + 6, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 5, this.y + this.height - 7, this.z + 5, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
    }

    @Override
    public void makeRoom() {
        this.makeShell();
    }

    static {
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE.id(), 0, 85.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_LIGHT.id(), 0, 5.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, 10.0);
    }
}

