/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.silver.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import teamport.aether.AetherMod;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.helper.MazeHelper;
import teamport.aether.helper.MetadataHelper;
import teamport.aether.helper.unboxed.IntPair;
import teamport.aether.world.feature.dungeon.silver.WorldFeatureAetherSilverDungeon;
import teamport.aether.world.feature.util.BlockPallet;
import teamport.aether.world.feature.util.WorldFeatureBlock;
import teamport.aether.world.feature.util.WorldFeatureComponent;

public class WorldFeatureSilverMaze {
    private static final int ENTRANCE = 1;
    private static final int ROOM_WIDTH = 7;
    private static final int ROOM_HEIGHT = 5;
    private static final int ROOM_COUNT = 27;
    private WorldFeatureComponent rooms;
    private WorldFeatureComponent chests;
    private WorldFeatureComponent doors;
    private Map<Integer, List<Integer>> spanningTree;
    private Random random;
    private Map<Integer, List<Integer>> graph;
    private static final BlockPallet ANGELIC_ROOM = new BlockPallet();
    private static final BlockPallet CHEST_OR_MIMIC;
    private static final BlockPallet CHEST_OR_MIMIC_ALT;
    private static final BlockPallet CHEST_OR_MIMIC_GARDEN;
    private static final BlockPallet GARDEN_DECO;
    private static final Map<Integer, List<Integer>> STATIC_GRAPH;

    public void addAdditionalStaircase(Random random) {
        int prev = -1;
        for (int LEVEL = 1; LEVEL >= 0; --LEVEL) {
            int staircaseAmount;
            for (int i = staircaseAmount = random.nextInt(2) + 1; i > 0; --i) {
                int index = random.nextInt(8);
                if (index == 1 && LEVEL == 0) {
                    ++index;
                }
                if (prev == index) {
                    ++index;
                }
                if (index > 7) {
                    index %= 7;
                }
                prev = index;
                this.graph.get(LEVEL * 9 + index).add((LEVEL + 1) * 9 + index);
                this.graph.get((LEVEL + 1) * 9 + index).add(LEVEL * 9 + index);
            }
        }
    }

    public void createMaze(Random random, int x, int y, int z) {
        this.random = random;
        this.rooms = new WorldFeatureComponent();
        this.doors = new WorldFeatureComponent();
        this.chests = new WorldFeatureComponent();
        this.graph = new HashMap<Integer, List<Integer>>(STATIC_GRAPH);
        this.addAdditionalStaircase(random);
        List<IntPair> edges = MazeHelper.randomMazeKruskal(STATIC_GRAPH, 27);
        this.spanningTree = MazeHelper.makeGraph(edges);
        boolean[] generated = new boolean[27];
        for (IntPair edge : edges) {
            int to = edge.getFirst();
            int from = edge.getSecond();
            generated[to] = true;
            this.createRoomMaze(to, from, x, y, z);
            if (generated[from]) continue;
            generated[from] = true;
            this.createRoomMaze(from, to, x, y, z);
        }
        this.rooms.add(new WorldFeatureComponent());
        this.rooms.add(this.doors);
    }

    public void createRoomMaze(int to, int from, int x, int y, int z) {
        int levelCurrent = to / 9;
        int columnCurrent = (to - levelCurrent * 9) / 3;
        int rowCurrent = to - levelCurrent * 9 - columnCurrent * 3;
        int roomX = x - 4 - 7 * rowCurrent;
        int roomY = y + 5 * levelCurrent;
        int roomZ = z + 4 + 7 * columnCurrent;
        Direction doorDirection = this.getDoorDirection(to, from);
        if (doorDirection == Direction.NONE) {
            AetherMod.LOGGER.error("SilverMazeRoom failed to generate a room at x:{}, y:{},  z:{},INDEX:{}, LEVEl:{}, COLUMN:{}, ROW:{}", new Object[]{x, y, z, to, levelCurrent, columnCurrent, rowCurrent});
            return;
        }
        if (doorDirection == Direction.UP) {
            this.createStaircase(roomX, roomY, roomZ);
            return;
        }
        if (doorDirection == Direction.DOWN) {
            this.createRoom(roomX, roomY, roomZ, doorDirection);
            return;
        }
        if (to == 1) {
            this.createHallway(roomX, roomY, roomZ, doorDirection);
            return;
        }
        if (this.spanningTree.get(to).size() > 2) {
            List<Integer> neighbor = this.spanningTree.get(to);
            int count = 0;
            for (int id : neighbor) {
                if (!this.getDoorDirection(to, id).isHorizontal()) continue;
                ++count;
            }
            if (count == neighbor.size()) {
                this.createCorridor(roomX, roomY, roomZ, doorDirection);
                return;
            }
        }
        if (this.spanningTree.get(to).size() == 1) {
            int index = this.random.nextInt(4);
            switch (index) {
                case 0: {
                    this.createTreasureRoom(roomX, roomY, roomZ, doorDirection);
                    return;
                }
                case 1: {
                    this.createSleepingChambers(roomX, roomY, roomZ, doorDirection);
                    return;
                }
                case 2: {
                    this.createGardenRoom(roomX, roomY, roomZ, doorDirection);
                    return;
                }
                case 3: {
                    this.createCorridor(roomX, roomY, roomZ, doorDirection);
                    return;
                }
            }
        }
        this.createRoom(roomX, roomY, roomZ, doorDirection);
    }

    private void createCorridor(int x, int y, int z, Direction doorDirection) {
        this.createHallway(x, y, z, doorDirection);
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 1, ANGELIC_ROOM.getRandom(this.random), false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 1, ANGELIC_ROOM.getRandom(this.random), false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 6, ANGELIC_ROOM.getRandom(this.random), false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 6, ANGELIC_ROOM.getRandom(this.random), false));
        this.chests.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 1, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
        this.chests.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 1, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
        this.chests.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 6, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
        this.chests.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 6, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
    }

    public void createHallway(int x, int y, int z, Direction doorDirection) {
        this.rooms.add(WorldFeatureComponent.drawShell(this.random, ANGELIC_ROOM, Direction.SOUTH, 8, Direction.UP, 6, Direction.WEST, 8, x, y, z, false));
        switch (doorDirection) {
            case NORTH: {
                this.doors.add(WorldFeatureComponent.drawPlane(0, 0, Direction.UP, 2, Direction.WEST, 2, x - 3, y + 1, z, false));
                break;
            }
            case EAST: {
                this.doors.add(WorldFeatureComponent.drawPlane(0, 0, Direction.UP, 2, Direction.SOUTH, 2, x, y + 1, z + 3, false));
                break;
            }
            case WEST: {
                this.doors.add(WorldFeatureComponent.drawPlane(0, 0, Direction.UP, 2, Direction.SOUTH, 2, x - 7, y + 1, z + 3, false));
                break;
            }
            default: {
                this.doors.add(WorldFeatureComponent.drawPlane(0, 0, Direction.UP, 2, Direction.WEST, 2, x - 3, y + 1, z + 7, false));
            }
        }
    }

    public void createRoom(int x, int y, int z, Direction doorDirection) {
        this.createHallway(x, y, z, doorDirection);
        this.rooms.add(WorldFeatureComponent.drawPlane(this.random, WorldFeatureAetherSilverDungeon.ANGELIC, Direction.SOUTH, 2, Direction.WEST, 2, x - 3, y + 1, z + 3, false));
        this.createChests(x, y, z);
    }

    public void createTreasureRoom(int x, int y, int z, Direction doorDirection) {
        this.createHallway(x, y, z, doorDirection);
        block6: for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            Direction dir = Direction.horizontalDirections[i];
            if (dir == doorDirection) continue;
            switch (dir) {
                case EAST: {
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, WorldFeatureAetherSilverDungeon.ANGELIC, Direction.SOUTH, 2, x - 1, y + 1, z + 3, false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 3, CHEST_OR_MIMIC.getRandom(this.random), false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 4, CHEST_OR_MIMIC.getRandom(this.random), false));
                    continue block6;
                }
                case WEST: {
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, WorldFeatureAetherSilverDungeon.ANGELIC, Direction.SOUTH, 2, x - 6, y + 1, z + 3, false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 3, CHEST_OR_MIMIC.getRandom(this.random), false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 4, CHEST_OR_MIMIC.getRandom(this.random), false));
                    continue block6;
                }
                case NORTH: {
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, WorldFeatureAetherSilverDungeon.ANGELIC, Direction.WEST, 2, x - 3, y + 1, z + 1, false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 3, y + 2, z + 1, CHEST_OR_MIMIC.getRandom(this.random), false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 4, y + 2, z + 1, CHEST_OR_MIMIC.getRandom(this.random), false));
                    continue block6;
                }
                case SOUTH: {
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, WorldFeatureAetherSilverDungeon.ANGELIC, Direction.WEST, 2, x - 3, y + 1, z + 6, false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 3, y + 2, z + 6, CHEST_OR_MIMIC.getRandom(this.random), false));
                    this.chests.add(WorldFeatureBlock.wfb(x - 4, y + 2, z + 6, CHEST_OR_MIMIC.getRandom(this.random), false));
                    continue block6;
                }
            }
        }
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 1, AetherBlocks.CARVED_ANGELIC.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 1, AetherBlocks.FENCE_PLANKS_SKYROOT_PAINTED.id(), DyeColor.WHITE.blockMeta << 4, true));
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 3, z + 1, Blocks.GLOWSTONE.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 6, AetherBlocks.CARVED_ANGELIC.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 6, AetherBlocks.FENCE_PLANKS_SKYROOT_PAINTED.id(), DyeColor.WHITE.blockMeta << 4, true));
        this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 3, z + 6, Blocks.GLOWSTONE.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 1, AetherBlocks.CARVED_ANGELIC.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 1, AetherBlocks.FENCE_PLANKS_SKYROOT_PAINTED.id(), DyeColor.WHITE.blockMeta << 4, true));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 3, z + 1, Blocks.GLOWSTONE.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 6, AetherBlocks.CARVED_ANGELIC.id(), 0, false));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 6, AetherBlocks.FENCE_PLANKS_SKYROOT_PAINTED.id(), DyeColor.WHITE.blockMeta << 4, true));
        this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 3, z + 6, Blocks.GLOWSTONE.id(), 0, false));
    }

    private void createGardenRoom(int x, int y, int z, Direction doorDirection) {
        this.createHallway(x, y, z, doorDirection);
        for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            Direction dir = Direction.horizontalDirections[i];
            if (dir == doorDirection) continue;
            switch (dir) {
                case EAST: {
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.GRASS_AETHER.id(), 0, Direction.SOUTH, 2, x - 1, y + 1, z + 3, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.LEAVES_SKYROOT.id(), 0, Direction.SOUTH, 2, x - 1, y + 4, z + 3, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, GARDEN_DECO, Direction.SOUTH, 2, x - 1, y + 2, z + 3, false));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 4, z + 2, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, dir)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 4, z + 5, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, dir)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 2, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.NORTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 3, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 4, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 5, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.SOUTH)));
                    break;
                }
                case WEST: {
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.GRASS_AETHER.id(), 0, Direction.SOUTH, 2, x - 6, y + 1, z + 3, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.LEAVES_SKYROOT.id(), 0, Direction.SOUTH, 2, x - 6, y + 4, z + 3, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, GARDEN_DECO, Direction.SOUTH, 2, x - 6, y + 2, z + 3, false));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 4, z + 2, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, dir)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 4, z + 5, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, dir)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 2, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.NORTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 1, z + 3, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 1, z + 4, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 5, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.SOUTH)));
                    break;
                }
                case NORTH: {
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.GRASS_AETHER.id(), 0, Direction.WEST, 2, x - 3, y + 1, z + 1, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.LEAVES_SKYROOT.id(), 0, Direction.WEST, 2, x - 3, y + 4, z + 1, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, GARDEN_DECO, Direction.WEST, 2, x - 3, y + 2, z + 1, false));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 4, z + 1, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, dir)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 4, z + 1, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, dir)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 1, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.EAST)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 4, y + 1, z + 2, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 3, y + 1, z + 2, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 1, z + 1, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.WEST)));
                    break;
                }
                default: {
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.GRASS_AETHER.id(), 0, Direction.WEST, 2, x - 3, y + 1, z + 6, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.LEAVES_SKYROOT.id(), 0, Direction.WEST, 2, x - 3, y + 4, z + 6, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(this.random, GARDEN_DECO, Direction.WEST, 2, x - 3, y + 2, z + 6, false));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 4, z + 6, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, Direction.SOUTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 4, z + 6, AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndDirection(DyeColor.GREEN, Direction.SOUTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 6, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.EAST)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 3, y + 1, z + 5, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 4, y + 1, z + 5, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, dir.getOpposite())));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 1, z + 6, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.WHITE, false, true, Direction.WEST)));
                }
            }
            this.placeGardenCorner(x - 1, y, z + 1);
            this.placeGardenCorner(x - 1, y, z + 6);
            this.placeGardenCorner(x - 6, y, z + 1);
            this.placeGardenCorner(x - 6, y, z + 6);
            this.rooms.add(WorldFeatureComponent.drawPlane(AetherBlocks.SLAB_BRICK_HOLYSTONE.id(), 0, Direction.SOUTH, 2, Direction.WEST, 2, x - 3, y + 1, z + 3, false));
        }
    }

    private void placeGardenCorner(int x, int y, int z) {
        this.rooms.add(WorldFeatureBlock.wfb(x, y + 1, z, AetherBlocks.BRICK_HOLYSTONE.id(), 0));
        this.chests.add(WorldFeatureBlock.wfb(x, y + 2, z, CHEST_OR_MIMIC_GARDEN.getRandom(this.random), false));
        this.rooms.add(WorldFeatureBlock.wfb(x, y + 4, z, Blocks.GLOWSTONE.id(), 0));
    }

    private void createSleepingChambers(int x, int y, int z, Direction doorDirection) {
        this.createHallway(x, y, z, doorDirection);
        for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            Direction dir = Direction.horizontalDirections[i];
            if (dir == doorDirection) continue;
            switch (dir) {
                case EAST: {
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.SLAB_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndLower(DyeColor.WHITE, 0), Direction.UP, 3, x - 1, y + 1, z + 3, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.SLAB_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndLower(DyeColor.PURPLE, 0), Direction.UP, 3, x - 1, y + 1, z + 4, false));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 4, z + 4, AetherBlocks.TORCH_AMBROSIUM.id(), MetadataHelper.maskDirectionHorizontal(0, MetadataHelper.getTorchMetadataFromDirection(dir))));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.NORTH), Direction.UP, 3, x - 1, y + 1, z + 2, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.SOUTH), Direction.UP, 3, x - 1, y + 1, z + 5, false));
                    break;
                }
                case WEST: {
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.SLAB_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndLower(DyeColor.WHITE, 0), Direction.UP, 3, x - 6, y + 1, z + 3, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.SLAB_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataFromDyeAndLower(DyeColor.PURPLE, 0), Direction.UP, 3, x - 6, y + 1, z + 4, false));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 4, z + 4, AetherBlocks.TORCH_AMBROSIUM.id(), MetadataHelper.maskDirectionHorizontal(0, MetadataHelper.getTorchMetadataFromDirection(dir))));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.NORTH), Direction.UP, 3, x - 6, y + 1, z + 2, false));
                    this.rooms.add(WorldFeatureComponent.drawLine(AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.SOUTH), Direction.UP, 3, x - 6, y + 1, z + 5, false));
                    break;
                }
                case NORTH: {
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 1, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.EAST)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 3, y + 1, z + 1, AetherBlocks.STAIRS_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataStairs(DyeColor.YELLOW, false, Direction.NORTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 4, y + 1, z + 1, AetherBlocks.STAIRS_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataStairs(DyeColor.YELLOW, false, Direction.NORTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 1, z + 1, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.WEST)));
                    break;
                }
                default: {
                    this.rooms.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 6, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.EAST)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 3, y + 1, z + 6, AetherBlocks.STAIRS_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataStairs(DyeColor.YELLOW, false, Direction.SOUTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 4, y + 1, z + 6, AetherBlocks.STAIRS_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.getMetadataStairs(DyeColor.YELLOW, false, Direction.SOUTH)));
                    this.rooms.add(WorldFeatureBlock.wfb(x - 5, y + 1, z + 6, AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), MetadataHelper.setMetadataTrapdoor(DyeColor.YELLOW, false, true, Direction.WEST)));
                }
            }
            this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 1, ANGELIC_ROOM.getRandom(this.random), false));
            this.chests.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 1, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
            this.rooms.add(WorldFeatureBlock.wfb(x - 1, y + 1, z + 6, ANGELIC_ROOM.getRandom(this.random), false));
            this.chests.add(WorldFeatureBlock.wfb(x - 1, y + 2, z + 6, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
            this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 1, ANGELIC_ROOM.getRandom(this.random), false));
            this.chests.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 1, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
            this.rooms.add(WorldFeatureBlock.wfb(x - 6, y + 1, z + 6, ANGELIC_ROOM.getRandom(this.random), false));
            this.chests.add(WorldFeatureBlock.wfb(x - 6, y + 2, z + 6, CHEST_OR_MIMIC_ALT.getRandom(this.random), false));
        }
    }

    public void createChests(int x, int y, int z) {
        int chestCount = 0;
        if (this.random.nextInt(3) == 0) {
            ++chestCount;
            this.chests.add(WorldFeatureBlock.wfb(x - 3, y + 2, z + 3, CHEST_OR_MIMIC.getRandom(this.random), false));
        }
        if (this.random.nextInt(3) == 0) {
            ++chestCount;
            this.chests.add(WorldFeatureBlock.wfb(x - 4, y + 2, z + 3, CHEST_OR_MIMIC.getRandom(this.random), false));
        }
        if (this.random.nextInt(3) == 0) {
            ++chestCount;
            this.chests.add(WorldFeatureBlock.wfb(x - 3, y + 2, z + 4, CHEST_OR_MIMIC.getRandom(this.random), false));
        }
        if (this.random.nextInt(2) == 0 || chestCount < 2) {
            this.chests.add(WorldFeatureBlock.wfb(x - 4, y + 2, z + 4, CHEST_OR_MIMIC.getRandom(this.random), false));
        }
    }

    public void createStaircase(int x, int y, int z) {
        this.rooms.add(WorldFeatureComponent.drawShell(this.random, ANGELIC_ROOM, Direction.SOUTH, 8, Direction.UP, 6, Direction.WEST, 8, x, y, z, false));
        this.doors.add(WorldFeatureComponent.drawPlane(0, 0, Direction.SOUTH, 4, Direction.WEST, 4, x - 2, y + 5, z + 2, false));
        this.doors.add(WorldFeatureComponent.drawVolume(this.random, WorldFeatureAetherSilverDungeon.ANGELIC, Direction.SOUTH, 2, Direction.WEST, 2, Direction.UP, 9, x - 3, y + 1, z + 3, false));
        this.createChests(x, y + 5, z);
        this.doors.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 2, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 0, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 3, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 2, y + 2, z + 4, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 0, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 2, y + 1, z + 4, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 2, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 2, y + 2, z + 5, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 3, y + 3, z + 5, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 0, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 3, y + 2, z + 5, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 2, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 4, y + 3, z + 5, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 5, y + 4, z + 5, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 0, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 5, y + 3, z + 5, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 2, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 5, y + 4, z + 4, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 5, y + 5, z + 3, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 0, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 5, y + 4, z + 3, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 2, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 5, y + 5, z + 2, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 4, y + 5, z + 2, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
        this.doors.add(WorldFeatureBlock.wfb(x - 3, y + 5, z + 2, AetherBlocks.SLAB_HOLYSTONE_POLISHED.id(), 1, false));
    }

    public Direction getDoorDirection(int to, int from) {
        int levelTo = to / 9;
        int columnTo = (to - levelTo * 9) / 3;
        int rowTo = to - levelTo * 9 - columnTo * 3;
        int levelFrom = from / 9;
        int columnFrom = (from - levelFrom * 9) / 3;
        int rowFrom = from - levelFrom * 9 - columnFrom * 3;
        if (columnFrom < columnTo) {
            return Direction.NORTH;
        }
        if (columnFrom > columnTo) {
            return Direction.SOUTH;
        }
        if (rowFrom > rowTo) {
            return Direction.WEST;
        }
        if (rowFrom < rowTo) {
            return Direction.EAST;
        }
        if (levelFrom > levelTo) {
            return Direction.UP;
        }
        if (levelFrom < levelTo) {
            return Direction.DOWN;
        }
        return Direction.NONE;
    }

    public WorldFeatureComponent getRooms() {
        return this.rooms;
    }

    public WorldFeatureComponent getChests() {
        return this.chests;
    }

    static {
        ANGELIC_ROOM.addEntry(AetherBlocks.CARVED_ANGELIC_LOCKED.id(), 0, 85.0);
        ANGELIC_ROOM.addEntry(AetherBlocks.CARVED_ANGELIC_LIGHT_LOCKED.id(), 0, 5.0);
        ANGELIC_ROOM.addEntry(AetherBlocks.CARVED_ANGELIC_TRAPPED_LOCKED.id(), 0, 10.0);
        CHEST_OR_MIMIC = new BlockPallet();
        CHEST_OR_MIMIC.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), DyeColor.SILVER.blockMeta << 4, 3.0);
        CHEST_OR_MIMIC.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), DyeColor.SILVER.blockMeta << 4, 3.0);
        CHEST_OR_MIMIC.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), DyeColor.YELLOW.blockMeta << 4, 1.0);
        CHEST_OR_MIMIC.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), DyeColor.YELLOW.blockMeta << 4, 1.0);
        CHEST_OR_MIMIC_ALT = new BlockPallet();
        CHEST_OR_MIMIC_ALT.addEntry(0, 4.0);
        CHEST_OR_MIMIC_ALT.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), DyeColor.SILVER.blockMeta << 4, 3.0);
        CHEST_OR_MIMIC_ALT.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), DyeColor.SILVER.blockMeta << 4, 3.0);
        CHEST_OR_MIMIC_ALT.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), DyeColor.YELLOW.blockMeta << 4, 1.0);
        CHEST_OR_MIMIC_ALT.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), DyeColor.YELLOW.blockMeta << 4, 1.0);
        CHEST_OR_MIMIC_GARDEN = new BlockPallet();
        CHEST_OR_MIMIC_GARDEN.addEntry(0, 3.0);
        CHEST_OR_MIMIC_GARDEN.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), DyeColor.GREEN.blockMeta << 4, 1.5);
        CHEST_OR_MIMIC_GARDEN.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), DyeColor.GREEN.blockMeta << 4, 1.5);
        CHEST_OR_MIMIC_GARDEN.addEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), DyeColor.LIME.blockMeta << 4, 1.5);
        CHEST_OR_MIMIC_GARDEN.addEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), DyeColor.LIME.blockMeta << 4, 1.5);
        GARDEN_DECO = new BlockPallet();
        GARDEN_DECO.addEntry(0, 20.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_PURPLE.id(), 128, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_PURPLE.id(), 160, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_PURPLE.id(), 192, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_PURPLE.id(), 224, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_WHITE.id(), 128, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_WHITE.id(), 160, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_WHITE.id(), 192, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.FLOWER_WHITE.id(), 224, 1.0);
        GARDEN_DECO.addEntry(AetherBlocks.TALLGRASS_AETHER.id(), 128, 4.0);
        GARDEN_DECO.addEntry(AetherBlocks.SAPLING_SKYROOT.id(), 224, 4.0);
        GARDEN_DECO.addEntry(AetherBlocks.SAPLING_OAK_GOLDEN.id(), 224, 4.0);
        STATIC_GRAPH = new HashMap<Integer, List<Integer>>();
        STATIC_GRAPH.put(0, new ArrayList<Integer>(Arrays.asList(1, 3)));
        STATIC_GRAPH.put(1, new ArrayList<Integer>(Arrays.asList(0, 2, 4)));
        STATIC_GRAPH.put(2, new ArrayList<Integer>(Arrays.asList(1, 5)));
        STATIC_GRAPH.put(3, new ArrayList<Integer>(Arrays.asList(0, 4, 6)));
        STATIC_GRAPH.put(4, new ArrayList<Integer>(Arrays.asList(1, 3, 5, 7)));
        STATIC_GRAPH.put(5, new ArrayList<Integer>(Arrays.asList(2, 4)));
        STATIC_GRAPH.put(6, new ArrayList<Integer>(Arrays.asList(3, 7)));
        STATIC_GRAPH.put(7, new ArrayList<Integer>(Arrays.asList(4, 6)));
        STATIC_GRAPH.put(8, new ArrayList<Integer>(Collections.singletonList(17)));
        STATIC_GRAPH.put(9, new ArrayList<Integer>(Arrays.asList(10, 12)));
        STATIC_GRAPH.put(10, new ArrayList<Integer>(Arrays.asList(9, 11, 13)));
        STATIC_GRAPH.put(11, new ArrayList<Integer>(Arrays.asList(10, 14)));
        STATIC_GRAPH.put(12, new ArrayList<Integer>(Arrays.asList(9, 13, 15)));
        STATIC_GRAPH.put(13, new ArrayList<Integer>(Arrays.asList(10, 12, 14, 16)));
        STATIC_GRAPH.put(14, new ArrayList<Integer>(Arrays.asList(11, 13)));
        STATIC_GRAPH.put(15, new ArrayList<Integer>(Arrays.asList(12, 16)));
        STATIC_GRAPH.put(16, new ArrayList<Integer>(Arrays.asList(13, 15)));
        STATIC_GRAPH.put(17, new ArrayList<Integer>(Arrays.asList(8, 26)));
        STATIC_GRAPH.put(18, new ArrayList<Integer>(Arrays.asList(19, 21)));
        STATIC_GRAPH.put(19, new ArrayList<Integer>(Arrays.asList(18, 20, 22)));
        STATIC_GRAPH.put(20, new ArrayList<Integer>(Arrays.asList(19, 23)));
        STATIC_GRAPH.put(21, new ArrayList<Integer>(Arrays.asList(18, 22, 24)));
        STATIC_GRAPH.put(22, new ArrayList<Integer>(Arrays.asList(19, 21, 23, 25)));
        STATIC_GRAPH.put(23, new ArrayList<Integer>(Arrays.asList(20, 22, 26)));
        STATIC_GRAPH.put(24, new ArrayList<Integer>(Arrays.asList(21, 25)));
        STATIC_GRAPH.put(25, new ArrayList<Integer>(Arrays.asList(22, 24, 26)));
        STATIC_GRAPH.put(26, new ArrayList<Integer>(Arrays.asList(17, 23, 25)));
    }
}

