/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.terrain;

import java.util.Random;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import org.jspecify.annotations.NonNull;
import teamport.aether.blocks.AetherBlocks;

public class WorldFeatureAetherOre
extends WorldFeatureOre {
    private final int numberOfBlocks;
    private final WorldFeatureOre.OreMap variantMap;
    private int minableBlockId;

    @MethodParametersAnnotation(names={"blockId", "numberOfBlocks"})
    public WorldFeatureAetherOre(int blockId, int numberOfBlocks) {
        super(blockId, numberOfBlocks);
        this.minableBlockId = blockId;
        this.numberOfBlocks = numberOfBlocks;
        this.variantMap = null;
    }

    @MethodParametersAnnotation(names={"blockId", "numberOfBlocks", "variantMap"})
    public WorldFeatureAetherOre(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull WorldFeatureOre.OreMap variantMap, int numberOfBlocks) {
        super(variantMap, numberOfBlocks);
        this.numberOfBlocks = numberOfBlocks;
        this.variantMap = variantMap;
    }

    public boolean place(World world, Random random, int xStart, int yStart, int zStart) {
        float f = random.nextFloat() * (float)Math.PI;
        double xMax = (float)(xStart + 8) + MathHelper.sin((float)f) * (float)this.numberOfBlocks / 8.0f;
        double xMin = (float)(xStart + 8) - MathHelper.sin((float)f) * (float)this.numberOfBlocks / 8.0f;
        double zMax = (float)(zStart + 8) + MathHelper.cos((float)f) * (float)this.numberOfBlocks / 8.0f;
        double zMin = (float)(zStart + 8) - MathHelper.cos((float)f) * (float)this.numberOfBlocks / 8.0f;
        double yMax = (double)(yStart + random.nextInt(3)) + 2.0;
        double yMin = (double)(yStart - random.nextInt(3)) + 2.0;
        for (int l = 0; l <= this.numberOfBlocks; ++l) {
            double d6 = xMax + (xMin - xMax) * (double)l / (double)this.numberOfBlocks;
            double d7 = yMax + (yMin - yMax) * (double)l / (double)this.numberOfBlocks;
            double d8 = zMax + (zMin - zMax) * (double)l / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.sin((float)((float)l * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)((float)l * (float)Math.PI / (float)this.numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int xVeinStart = MathHelper.floor((double)(d6 - d10 / 2.0));
            int yVeinStart = MathHelper.floor((double)(d7 - d11 / 2.0));
            int zVeinStart = MathHelper.floor((double)(d8 - d10 / 2.0));
            int xVeinEnd = MathHelper.floor((double)(d6 + d10 / 2.0));
            int yVeinEnd = MathHelper.floor((double)(d7 + d11 / 2.0));
            int zVeinEnd = MathHelper.floor((double)(d8 + d10 / 2.0));
            for (int x = xVeinStart; x <= xVeinEnd; ++x) {
                double d12 = ((double)x + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int y = yVeinStart; y <= yVeinEnd; ++y) {
                    double d13 = ((double)y + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int z = zVeinStart; z <= zVeinEnd; ++z) {
                        int blockId;
                        double d14 = ((double)z + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        if (this.variantMap != null) {
                            blockId = world.getBlockId(x, y, z);
                            if (blockId <= 0 || !this.variantMap.containsKey(blockId)) continue;
                            world.setBlock(x, y, z, this.variantMap.get(blockId));
                            continue;
                        }
                        blockId = world.getBlockId(x, y, z);
                        if (blockId != AetherBlocks.COBBLE_HOLYSTONE.id()) continue;
                        world.setBlock(x, y, z, this.minableBlockId);
                    }
                }
            }
        }
        return true;
    }
}

